<?php

namespace BackendBundle\Entity;

/**
 * Usuario
 */
class Usuario
{
    /**
     * @var integer
     */
    private $idusuario;

    /**
     * @var string
     */
    private $nombres;

    /**
     * @var string
     */
    private $apellidos;

    /**
     * @var string
     */
    private $correo;

    /**
     * @var string
     */
    private $contrasena;

    /**
     * @var string
     */
    private $rfc;

    /**
     * @var string
     */
    private $foto = 'NULL';

    /**
     * @var string
     */
    private $telefono = 'NULL';

    /**
     * @var string
     */
    private $celular;

    /**
     * @var \DateTime
     */
    private $fechacreacion = 'current_timestamp()';

    /**
     * @var boolean
     */
    private $usractivo;

    /**
     * @var \BackendBundle\Entity\Ciudad
     */
    private $idciudad;

    /**
     * @var \BackendBundle\Entity\Rol
     */
    private $idrol;


    /**
     * Get idusuario
     *
     * @return integer
     */
    public function getIdusuario()
    {
        return $this->idusuario;
    }

    /**
     * Set nombres
     *
     * @param string $nombres
     *
     * @return Usuario
     */
    public function setNombres($nombres)
    {
        $this->nombres = $nombres;

        return $this;
    }

    /**
     * Get nombres
     *
     * @return string
     */
    public function getNombres()
    {
        return $this->nombres;
    }

    /**
     * Set apellidos
     *
     * @param string $apellidos
     *
     * @return Usuario
     */
    public function setApellidos($apellidos)
    {
        $this->apellidos = $apellidos;

        return $this;
    }

    /**
     * Get apellidos
     *
     * @return string
     */
    public function getApellidos()
    {
        return $this->apellidos;
    }

    /**
     * Set correo
     *
     * @param string $correo
     *
     * @return Usuario
     */
    public function setCorreo($correo)
    {
        $this->correo = $correo;

        return $this;
    }

    /**
     * Get correo
     *
     * @return string
     */
    public function getCorreo()
    {
        return $this->correo;
    }

    /**
     * Set contrasena
     *
     * @param string $contrasena
     *
     * @return Usuario
     */
    public function setContrasena($contrasena)
    {
        $this->contrasena = $contrasena;

        return $this;
    }

    /**
     * Get contrasena
     *
     * @return string
     */
    public function getContrasena()
    {
        return $this->contrasena;
    }

    /**
     * Set rfc
     *
     * @param string $rfc
     *
     * @return Usuario
     */
    public function setRfc($rfc)
    {
        $this->rfc = $rfc;

        return $this;
    }

    /**
     * Get rfc
     *
     * @return string
     */
    public function getRfc()
    {
        return $this->rfc;
    }

    /**
     * Set foto
     *
     * @param string $foto
     *
     * @return Usuario
     */
    public function setFoto($foto)
    {
        $this->foto = $foto;

        return $this;
    }

    /**
     * Get foto
     *
     * @return string
     */
    public function getFoto()
    {
        return $this->foto;
    }

    /**
     * Set telefono
     *
     * @param string $telefono
     *
     * @return Usuario
     */
    public function setTelefono($telefono)
    {
        $this->telefono = $telefono;

        return $this;
    }

    /**
     * Get telefono
     *
     * @return string
     */
    public function getTelefono()
    {
        return $this->telefono;
    }

    /**
     * Set celular
     *
     * @param string $celular
     *
     * @return Usuario
     */
    public function setCelular($celular)
    {
        $this->celular = $celular;

        return $this;
    }

    /**
     * Get celular
     *
     * @return string
     */
    public function getCelular()
    {
        return $this->celular;
    }

    /**
     * Set fechacreacion
     *
     * @param \DateTime $fechacreacion
     *
     * @return Usuario
     */
    public function setFechacreacion($fechacreacion)
    {
        $this->fechacreacion = $fechacreacion;

        return $this;
    }

    /**
     * Get fechacreacion
     *
     * @return \DateTime
     */
    public function getFechacreacion()
    {
        return $this->fechacreacion;
    }

    /**
     * Set usractivo
     *
     * @param boolean $usractivo
     *
     * @return Usuario
     */
    public function setUsractivo($usractivo)
    {
        $this->usractivo = $usractivo;

        return $this;
    }

    /**
     * Get usractivo
     *
     * @return boolean
     */
    public function getUsractivo()
    {
        return $this->usractivo;
    }

    /**
     * Set idciudad
     *
     * @param \BackendBundle\Entity\Ciudad $idciudad
     *
     * @return Usuario
     */
    public function setIdciudad(\BackendBundle\Entity\Ciudad $idciudad = null)
    {
        $this->idciudad = $idciudad;

        return $this;
    }

    /**
     * Get idciudad
     *
     * @return \BackendBundle\Entity\Ciudad
     */
    public function getIdciudad()
    {
        return $this->idciudad;
    }

    /**
     * Set idrol
     *
     * @param \BackendBundle\Entity\Rol $idrol
     *
     * @return Usuario
     */
    public function setIdrol(\BackendBundle\Entity\Rol $idrol = null)
    {
        $this->idrol = $idrol;

        return $this;
    }

    /**
     * Get idrol
     *
     * @return \BackendBundle\Entity\Rol
     */
    public function getIdrol()
    {
        return $this->idrol;
    }
}
