<?php

namespace AppBundle\Services;

//se usa para los tokens
use Firebase\JWT\JWT;
use BackendBundle\Entity\Ciudad;
//añadir a services yml
class JwtAuth {
    
    public $manager;
    public $key = "clave-secreta";
    
    public function __construct($manager){
        
        $this->manager = $manager;
        
    }
    
    //metodo para el logeo
    public function signup($email, $password, $getHash = false){
        
        $key = $this->key;
        
        $user= $this->manager->getRepository("BackendBundle:Usuario")->findOneBy(
                    array(
                        "correo" => $email,
                        "contrasena" => $password
                    )
                );
        
        
        $signup =false;
        if(is_object($user)){
            $signup = true;
        }
        
        if($signup == true){

            $token = array(
                "sub" => $user->getIdUsuario(),
                "nombres"  => $user->getNombres(),
                "apellidos" => $user->getApellidos(),
                "contrasena" => $user->getContrasena(),
                "correo" => $user->getCorreo(),
                "rfc" => $user->getRfc(),
                "idciudad" => $user->getIdciudad()->getIdciudad(),
                "idrol" => $user->getIdrol()->getIdrol()
            ); 
            
            $jwt = JWT::encode($token, $key, 'HS256');
            $decode = JWT::decode($jwt, $key, array('HS256'));
            
            if($getHash == false){
                return $jwt;
            }else{
                return $decode;
            }
            
            //return array( "status" => "Success", "data" => "Login Success!!");
        }else{
            return array( "status" => "error", "data" => "Login Failed!!");
        }
    }
    
     //funcion de validacion de token (token, saber si los dato sestan encriptados o no)
    public function checkToken($jwt, $getIdentity = false){
        
        $key = $this->key;
        $auth = false; 
        
        try {
            
            $decode = JWT::decode($jwt, $key, array('HS256'));
            
        } catch (\UnexpectedValueException $e) {
            $auth = false; 
        }catch (\DomainException $e) {
            $auth = false; 
        }
       
        if(isset($decode->nombres)){
            $auth = TRUE;
        }else{
            $auth = false;
        }
        
        if($getIdentity == true){
            return $decode;
        }else{
            return $auth;
        }
    }
}


