<?php
namespace AppBundle\Services;

class Helpers {
    
    //tenemos que agregar en las configuraciones de los servicios para poder usar el jwt en todos lados
    public $jwt_auth;
    
    public function __construct($jwt_auth) {
        $this->jwt_auth = $jwt_auth;
    }
    
    //funcion de creacion de autentificacion de logeo
    public function authCheck($hash, $getIdentity = false){
        
        $jwt_auth = $this->jwt_auth;
        $auth = false;
        
        if($hash != null ){
            if($getIdentity == false){
                $check_token = $jwt_auth->checkToken($hash);
                if($check_token == true){
                    $auth = true;
                }
            }else{
                $check_token = $jwt_auth->checkToken($hash, true);
                $auth = $check_token;
            }
        }
        
        return $auth;
    }


    //Funcion para convertir a json cualquier cosa --- add to services in app/config/services.yml
        /*
         * normalizers = Usada para tranzformar a matrices
         * encoders = convierte cualquier cosa a json
         * serializer = serializa las dos variables anteriores 
         * json = almacena el archivo generado en json
         * response = generamos una variable de tipo respuesta http la cual le agregamos como contenido el json
         * y agremos los datos del contenido
        */
    public function json($data){

        $normalizers = array(new \Symfony\Component\Serializer\Normalizer\GetSetMethodNormalizer());
        $encoders = array("json" => new \Symfony\Component\Serializer\Encoder\JsonEncoder());
        $serializer = new \Symfony\Component\Serializer\Serializer($normalizers, $encoders);
        $json = $serializer->serialize($data, 'json');
        
        //instanciamos el objeto para mandarlo por http
        $response = new \Symfony\Component\HttpFoundation\Response();
        $response->setContent($json);
        $response->headers->set("Content-Type", "application/json");
        
        return $response;
    }
    
    public function hola(){
        return "hola desde el servicio";
    }
    
}
