<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackendBundle\Entity\Usuario;

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

/**
 * Description of TallerController
 *
 * @author brianaboytesmorales
 */
class TallerController extends Controller {

    public function selecttecnicosAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            if ($idrol == 1 || $idrol == 2 || $idrol == 3) {

                                $json = $request->get("json", null);
                                
                                $params = json_decode($json);
                                $idtaller = ( $params->idtaller != null ) ? $params->idtaller : null;

                                if ($idtaller != 0) {
                                    $query = "SELECT "
                                            . "usuario.idusuario, usuario.nombres, usuario.apellidos, usuario.idciudad, "
                                            . "usuario.correo, usuario.rfc, usuario.telefono, usuario.celular, "
                                            . "usuario.usractivo, ciudad.nombreciudad "
                                            . "FROM "
                                            . "tecnico "
                                            . "INNER JOIN "
                                            . "usuario on usuario.idusuario = tecnico.idusuario "
                                            . "INNER JOIN "
                                            . "ciudad on ciudad.idciudad = usuario.idciudad "
                                            . "WHERE tecnico.idtaller = {$idtaller}";

                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $idtecnicos = $stmt->fetchAll();

                                    if (count($idtecnicos) != 0) {

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "Tecnicos encontrados!!",
                                            "tecnicos" => $idtecnicos
                                        );
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 400,
                                            "msg" => "no hay tecnicos!!"
                                        );
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }

    public function selectcoberturaAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $json = $request->get("json", null);
                    $params = json_decode($json);
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            if ($json != null) {

                                $idciudad = ( $params->idciudad != null ) ? $params->idciudad : null;

                                if ($idciudad != null) {

                                    $query = "SELECT "
                                            . "*"
                                            . "FROM "
                                            . "cobertura "
                                            . "LEFT JOIN "
                                            . "taller on cobertura.idtaller = taller.idtaller "
                                            . "WHERE cobertura.idciudad = {$idciudad} AND taller.talleractivo = 1";

                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $isset_cobertura = $stmt->fetchAll();

                                    if (count($isset_cobertura) != 0) {
                                        
                                        $usuario = intval($isset_cobertura[0]["idusuario"]);
                                        $ciudad = intval($isset_cobertura[0]["idciudad"]);

                                        $query = "SELECT "
                                                . "*"
                                                . "FROM "
                                                . "usuario "
                                                . "WHERE usuario.idusuario = {$usuario} AND usuario.usractivo = 1";

                                        $db = $em->getConnection();
                                        $stmt = $db->prepare($query);

                                        $params = array();

                                        $stmt->execute($params);

                                        $isset_usuario = $stmt->fetchAll();
                                        
                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "cobertura encontrada!!",
                                            "taller" => $isset_cobertura
                                        );
                                        
                                        if($isset_usuario != 0){
                                            $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "cobertura encontrada!!",
                                            "taller" => $isset_cobertura,
                                            "usuario" => $isset_usuario
                                        );
                                        }
                                        
                                        $query = "SELECT "
                                                . "*"
                                                . "FROM "
                                                . "ciudad "
                                                . "WHERE ciudad.idciudad = {$ciudad}";

                                        $db = $em->getConnection();
                                        $stmt = $db->prepare($query);

                                        $params = array();

                                        $stmt->execute($params);

                                        $isset_ciudad = $stmt->fetchAll();
                                        
                                        if($isset_ciudad != 0){
                                            $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "cobertura encontrada!!",
                                            "taller" => $isset_cobertura,
                                            "usuario" => $isset_usuario,
                                            "ciudad" => $isset_ciudad
                                        );
                                        }

                                        
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 401,
                                            "msg" => "no hay talleres para esa ciudad!!"
                                        );
                                    }
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            } else {

                                $query = "SELECT "
                                        . "*"
                                        . "FROM "
                                        . "taller WHERE taller.talleractivo = 1";


                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $isset_cobertura = $stmt->fetchAll();
                                if (count($isset_cobertura) != 0) {

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "cobertura encontrados!!",
                                        "taller" => $isset_cobertura
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "no hay cobertura en la BD!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    /* FUNCION PARA OBTENER A LOS TALLERES*/
    public function selecttallerAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );
                        
                        if (count($isset_user) != 0) {
                            
                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;
                            
                            $json = $request->get("json", null);
                            
                            $jsondecode = json_decode($json);
                            $pagina = ( $jsondecode->pagina != null ) ? $jsondecode->pagina : null;

                            //$inicio = 0; //princiopio de busqueda en la bd por reporte

                            //PAGINACION: OBTENCION DE DATOS POR PARTES
                            /*if( $pagina > 15) {
                                $inicio = $pagina - 15;
                            }*/
                            if ($pagina === null || $pagina === "") {
                                $pagina = 0;
                            }
                            //var_dump($pagina);
                            if ($idrol == 1 || $idrol == 2) {

                                $query = "SELECT DISTINCT * FROM "
                                        . "taller "
                                        . "LEFT JOIN "
                                        . "ciudad on taller.idciudad = ciudad.idciudad "
                                        . "LEFT JOIN "
                                        . "usuario on usuario.idusuario = taller.idusuario "
                                        . "LEFT JOIN "
                                        . "estado on ciudad.idestado = estado.idestado "
                                        . "LEFT JOIN "
                                        . "zona on estado.idzona = zona.idzona WHERE taller.talleractivo = 1 "
                                        . "ORDER BY taller.idtaller DESC LIMIT $pagina,15 ";
                            }

                            $db = $em->getConnection();
                            $stmt = $db->prepare($query);

                            $params = array();

                            $stmt->execute($params);

                            $reportes = $stmt->fetchAll();

                            if (count($reportes) != 0) {

                                $data = array(
                                    "status" => "succes!!",
                                    "code" => 200,
                                    "msg" => "talleres encontrados!!",
                                    "talleres" => $reportes
                                );
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 401,
                                    "msg" => "no hay talleres!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function selecttallerbsAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            $json = $request->get("json", null);

                            $jsondecode = json_decode($json);
                            
                            $idtaller = ( $jsondecode->idtaller != null ) ? $jsondecode->idtaller : null;
                            $idestado = ( $jsondecode->idestado != null ) ? $jsondecode->idestado : null;
                            $idciudad = ( $jsondecode->idciudad != null ) ? $jsondecode->idciudad : null;
                            $idzona = ( $jsondecode->idzona != null ) ? $jsondecode->idzona : null;
                            $idusuario = ( $jsondecode->idusuario != null ) ? $jsondecode->idusuario : null;
                            
                            $where = "";
                            if($idtaller != null) {
                                $where = "taller.idtaller = {$idtaller}";
                            } else if ($idestado != null) {
                                $where = "estado.idestado = {$idestado}";
                            } else if ($idciudad != null) {
                                $where = "ciudad.idciudad = {$idciudad}";
                            } else if ($idzona != null) {
                                $where = "zona.idzona = {$idzona}";
                            } else if ($idusuario != null){
                                $where = "usuario.idusuario = {$idusuario}";
                            }
                           
                            //var_dump($pagina);
                            if ($idrol == 1 || $idrol == 2 || $idrol == 3) {

                                $query = "SELECT DISTINCT * FROM "
                                        . "taller "
                                        . "LEFT JOIN "
                                        . "ciudad on taller.idciudad = ciudad.idciudad "
                                        . "LEFT JOIN "
                                        . "usuario on usuario.idusuario = taller.idusuario "
                                        . "LEFT JOIN "
                                        . "estado on ciudad.idestado = estado.idestado "
                                        . "LEFT JOIN "
                                        . "zona on estado.idzona = zona.idzona "
                                        . "WHERE {$where} AND taller.talleractivo = 1 "
                                        . "ORDER BY taller.idtaller DESC";
                            }

                            $db = $em->getConnection();
                            $stmt = $db->prepare($query);

                            $params = array();

                            $stmt->execute($params);

                            $reportes = $stmt->fetchAll();

                            if (count($reportes) != 0) {

                                $data = array(
                                    "status" => "succes!!",
                                    "code" => 200,
                                    "msg" => "talleres encontrados!!",
                                    "talleres" => $reportes
                                );
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 401,
                                    "msg" => "no hay talleres!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function newAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            $json = $request->get("json", null);

                            $jsondecode = json_decode($json);

                            $idusuario = ( $jsondecode->idusuario != null ) ? $jsondecode->idusuario : null;
                            $idciudad = ( $jsondecode->idciudad != null ) ? $jsondecode->idciudad : null;
                            $nombrecomercial = ( $jsondecode->nombrecomercial != null ) ? $jsondecode->nombrecomercial : null;
                            $cptaller = ( $jsondecode->cptaller != null ) ? $jsondecode->cptaller : null;
                            $telefonotaller = ( $jsondecode->telefonotaller != null ) ? $jsondecode->telefonotaller : null;
                            $celulartaller = ( $jsondecode->celulartaller != null ) ? $jsondecode->celulartaller : null;
                            $correotaller = ( $jsondecode->correotaller != null ) ? $jsondecode->correotaller : null;
                            $coloniataller = ( $jsondecode->coloniataller != null ) ? $jsondecode->coloniataller : null;
                            $calletaller = ( $jsondecode->calletaller != null ) ? $jsondecode->calletaller : null;
                            $ninteriortaller = ( $jsondecode->ninteriortaller != null ) ? $jsondecode->ninteriortaller : null;
                            $nexteriortaller = ( $jsondecode->nexteriortaller != null ) ? $jsondecode->nexteriortaller : null;
                            $latitud = ( $jsondecode->latitud != null ) ? $jsondecode->latitud : null;
                            $longitud = ( $jsondecode->longitud != null ) ? $jsondecode->longitud : null;

                            /* -----------------------CONDICINES DE BUSQUEDA------------------------ */
                            if ($idusuario != null && $idciudad != null && $nombrecomercial != null && $cptaller != null && $cptaller != null) {


                                $query = "INSERT INTO "
                                        . "taller"
                                        . "(idusuario, idciudad, nombrecomercial, cptaller, telefonotaller, "
                                        . "celulartaller, correotaller, coloniataller, calletaller, ninteriortaller, nexteriortaller, "
                                        . "latitud, longitud, talleractivo) "
                                        . "VALUES "
                                        . "($idusuario, $idciudad, '$nombrecomercial', '$cptaller', '$telefonotaller', "
                                        . "'$celulartaller', '$correotaller', '$coloniataller', '$calletaller', '$ninteriortaller', '$nexteriortaller', "
                                        . "'$latitud', '$longitud', 1)";
                                
                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);
                                $params = array();
                                $stmt->execute($params);

                                if (count($stmt) != 0) {

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "Taller Insertado!!"
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 401,
                                        "msg" => "Error al insertar un taller!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function agregartecnicoAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            $json = $request->get("json", null);

                            $jsondecode = json_decode($json);

                            $idtaller = ( $jsondecode->idtaller != null ) ? $jsondecode->idtaller : null;
                            $idtecnico = ( $jsondecode->idtecnico != null ) ? $jsondecode->idtecnico : null;

                            /* -----------------------CONDICINES DE BUSQUEDA------------------------ */
                            if ($idtaller != null && $idtecnico != null) {


                                $query = "SELECT * FROM tecnico "
                                        . "WHERE idtaller = $idtaller AND idusuario = $idtecnico";

                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $idtecnicos = $stmt->fetchAll();

                                if (count($idtecnicos) == 0) {
                                    $query = "INSERT INTO "
                                            . "tecnico "
                                            . "(idtaller, idusuario) "
                                            . "VALUES "
                                            . "({$idtaller},{$idtecnico})";

                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    if (count($stmt) != 0) {

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "Taller Insertado!!"
                                        );
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 401,
                                            "msg" => "Error al insertar un taller!!"
                                        );
                                    }
                                } else {
                                    $data = array(
                                            "status" => "error",
                                            "code" => 405,
                                            "msg" => "El tecnico ya ha sido desigando!!"
                                        );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function getcoberturaciudadAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $json = $request->get("json", null);
                    $params = json_decode($json);
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            if ($json != null) {

                                $idtaller = ( $params->idtaller != null ) ? $params->idtaller : null;

                                if ($idtaller != null) {

                                    $query = "SELECT "
                                            . "*"
                                            . " FROM "
                                            . "cobertura "
                                            . "LEFT JOIN "
                                            . "ciudad on cobertura.idciudad = ciudad.idciudad LEFT JOIN estado on estado.idestado = ciudad.idestado LEFT JOIN zona on zona.idzona = estado.idestado "
                                            . "WHERE cobertura.idtaller = {$idtaller}";

                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $isset_cobertura = $stmt->fetchAll();

                                    if (count($isset_cobertura) != 0) {
                                        
                                        $data = array(
                                            "status" => "success",
                                            "code" => 200,
                                            "msg" => "ciudades encontradas!!",
                                            "ciudades" => $isset_cobertura
                                        );
                                        
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 401,
                                            "msg" => "no se ha seleccionado cobertura!!"
                                        );
                                    }
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            } 
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    /* AGREGAR COBERTURA */
    public function setcoberturaciudadAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            $json = $request->get("json", null);

                            $jsondecode = json_decode($json);

                            $idtaller = ( $jsondecode->idtaller != null ) ? $jsondecode->idtaller : null;
                            $idciudad = ( $jsondecode->idciudad != null ) ? $jsondecode->idciudad : null;

                            /* -----------------------CONDICINES DE BUSQUEDA------------------------ */
                            if ($idtaller != null && $idciudad != null) {


                                $query = "SELECT * FROM cobertura "
                                        . "WHERE idtaller = $idtaller AND idciudad = $idciudad";

                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $idtecnicos = $stmt->fetchAll();

                                if (count($idtecnicos) == 0) {
                                    $query = "INSERT INTO "
                                            . "cobertura "
                                            . "(idtaller, idciudad) "
                                            . "VALUES "
                                            . "({$idtaller},{$idciudad})";

                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    if (count($stmt) != 0) {

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "coberuta Insertado!!"
                                        );
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 401,
                                            "msg" => "Error al insertar un coberuta!!"
                                        );
                                    }
                                } else {
                                    $data = array(
                                            "status" => "error",
                                            "code" => 405,
                                            "msg" => "la coberuta ya ha sido designada!!"
                                        );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function deletetecnicoAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            $json = $request->get("json", null);

                            if ($json != null) {

                                $params = json_decode($json);

                                $idtaller = ( $params->idtaller != null ) ? $params->idtaller : null;
                                $idusuario = ( $params->idusuario != null ) ? $params->idusuario : null;

                                //SOLO SI SE LLAMA DESDE ALGUN REPORTE
                                if ($idtaller != null) {

                                    $query = "DELETE FROM tecnico WHERE idtaller = {$idtaller} AND idusuario = {$idusuario}";


                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "tecnico eliminado!!"
                                        );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function updatetallerAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            $json = $request->get("json", null);

                            $jsondecode = json_decode($json);

                            $idusuario = ( $jsondecode->idusuario != null ) ? $jsondecode->idusuario : null;
                            $idciudad = ( $jsondecode->idciudad != null ) ? $jsondecode->idciudad : null;
                            $nombrecomercial = ( $jsondecode->nombrecomercial != null ) ? $jsondecode->nombrecomercial : null;
                            $cptaller = ( $jsondecode->cptaller != null ) ? $jsondecode->cptaller : null;
                            $telefonotaller = ( $jsondecode->telefonotaller != null ) ? $jsondecode->telefonotaller : null;
                            $celulartaller = ( $jsondecode->celulartaller != null ) ? $jsondecode->celulartaller : null;
                            $correotaller = ( $jsondecode->correotaller != null ) ? $jsondecode->correotaller : null;
                            $coloniataller = ( $jsondecode->coloniataller != null ) ? $jsondecode->coloniataller : null;
                            $calletaller = ( $jsondecode->calletaller != null ) ? $jsondecode->calletaller : null;
                            $ninteriortaller = ( $jsondecode->ninteriortaller != null ) ? $jsondecode->ninteriortaller : null;
                            $nexteriortaller = ( $jsondecode->nexteriortaller != null ) ? $jsondecode->nexteriortaller : null;
                            $latitud = ( $jsondecode->latitud != null ) ? $jsondecode->latitud : null;
                            $longitud = ( $jsondecode->longitud != null ) ? $jsondecode->longitud : null;
                            $talleractivo = ( $jsondecode->talleractivo != null ) ? $jsondecode->talleractivo : null;
                            $idtaller = ( $jsondecode->idtaller != null ) ? $jsondecode->idtaller : null;
                            /* -----------------------CONDICINES DE BUSQUEDA------------------------ */
                            if ($idusuario != null && $idciudad != null && $nombrecomercial != null && $cptaller != null ) {


                                $query = "UPDATE "
                                        . "taller "
                                        . "SET idusuario = $idusuario, idciudad = $idciudad, nombrecomercial = '$nombrecomercial', "
                                        . "cptaller = '$cptaller', telefonotaller = '$telefonotaller', celulartaller = '$celulartaller', "
                                        . "correotaller = '$correotaller', coloniataller = '$coloniataller', calletaller = '$calletaller', "
                                        . "ninteriortaller = '$ninteriortaller', nexteriortaller = '$nexteriortaller', latitud = '$latitud', "
                                        . "longitud = '$longitud', talleractivo = $talleractivo "
                                        . "WHERE idtaller = $idtaller";
                                
                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);
                                $params = array();
                                $stmt->execute($params);

                                if (count($stmt) != 0) {

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "Taller actualizado!!"
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 401,
                                        "msg" => "Error al actualizar taller!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
}
