<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackendBundle\Entity\Usuario;

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

/**
 * Description of ServicioController
 *
 * @author brianaboytesmorales
 */
class ServicioController extends Controller {
    public function selectAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $json = $request->get("json", null);
                    $params = json_decode($json);
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            if ($json != null) {

                                $idservicio = ( $params->idservicio != null ) ? $params->idservicio : null;

                                if ($idservicio != null) {

                                    $query = "SELECT "
                                        . "*"
                                        . "FROM "
                                        . "tiposervicio "
                                        . "WHERE idtiposervicio = {$idservicio}";


                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $isset_ciudad = $stmt->fetchAll();

                                    if (count($isset_ciudad) != 0) {

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "servicio encontrado!!",
                                            "ciudad" => $isset_ciudad
                                        );
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 400,
                                            "msg" => "El servicio no existe en la BD!!"
                                        );
                                    }
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            } else {

                                $query = "SELECT "
                                        . "*"
                                        . "FROM "
                                        . "tiposervicio ";


                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $isset_corporativo = $stmt->fetchAll();
                                if (count($isset_corporativo) != 0) {

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "servicios encontrados!!",
                                        "servicio" => $isset_corporativo
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "no hay servicios en la BD!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
}
