<?php

namespace AppBundle\Controller;

/**
 * Description of ReportesController
 *
 * @author brianaboytesmorales
 */
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackendBundle\Entity\Usuario;

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

class ReporteController extends Controller {

    public function selectAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );
                        
                        if (count($isset_user) != 0) {
                            
                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;
                            
                            $json = $request->get("json", null);
                            
                            $jsondecode = json_decode($json);
                            
                            $pagina = ( $jsondecode->pagina != null ) ? $jsondecode->pagina : null;
                            
                            $estatus = ( $jsondecode->status != null ) ? $jsondecode->status : null;
                            
                            $where = ""; //variable del where para la busqueda de reportes por estatus
                            /*$inicio = 0;*/ //princiopio de busqueda en la bd por reporte
                            //
                            //DESIGNAR BUSQUEDA POR ESTATUS
                            if($estatus == 10){
                                $where = "reporte.idestatus > 0 AND reporte.idestatus < 6";
                            } else {
                                $where = "idestatus = {$estatus}";
                            }
                            //PAGINACION: OBTENCION DE DATOS POR PARTES
                            /*if( $pagina > 15) {
                                $inicio = $pagina - 15;
                            }*/
                            
                            if($pagina === null || $pagina === ""){
                                $pagina = 0;
                            }
                            //var_dump($pagina);
                            if ($idrol == 1 || $idrol == 2) {

                                $query = ""
                                        . "SELECT "
                                        . "ciudad.nombreciudad, ciudad.idciudad, "
                                        . "tiposervicio.idtiposervicio, tiposervicio.nombreservicio, "
                                        . "modelo.idmodelo, modelo.nombremodelo, clasificacion.idclasificacion, "
                                        . "clasificacion.nombreclasificacion, reporte.horaatencion, "
                                        . "reporte.idreporte, corporativo.sla, "
                                        . "reporte.diagnostico, reporte.diasatencion, "
                                        . "reporte.horatermino, reporte.idestatus, reporte.folio, reporte.fechacreacion, "
                                        . "reporte.falla, subclasificacion.nomsubclf, reporte.fechacierre, reporte.longitud, "
                                        . "reporte.latitud, reporte.nompv, reporte.callepv, reporte.nexteriorpv, reporte.ninteriorpv, "
                                        . "reporte.coloniapv, reporte.entrecalleuno, reporte.entrecalledos, reporte.referenciapv, "
                                        . "reporte.nomcliente, reporte.apecliente, reporte.celularcliente, reporte.telefonocliente, "
                                        . "reporte.correocliente "
                                        . "FROM "
                                        . "reporte "
                                        . "LEFT JOIN "
                                        . "ciudad ON "
                                        . "reporte.idciudad = ciudad.idciudad "
                                        . "LEFT JOIN "
                                        . "tiposervicio ON reporte.idtiposervicio = tiposervicio.idtiposervicio "
                                        . "LEFT JOIN "
                                        . "modelo ON reporte.idmodelo = modelo.idmodelo "
                                        . "LEFT JOIN "
                                        . "subclasificacion on reporte.idsubclf = subclasificacion.idsubclasificacion "
                                        . "LEFT JOIN "
                                        . "clasificacion on subclasificacion.idclasificacion = clasificacion.idclasificacion "
                                        . "LEFT JOIN "
                                        . "corporativo on reporte.idcorporativo = corporativo.idcorporativo "
                                        . "WHERE {$where} "
                                        . "ORDER BY reporte.idreporte DESC LIMIT $pagina,15 ";
                                        
                            } else if ($idrol == 3 || $idrol == 4) {
                                
                                $where = "";
                                if($idrol == 3) {
                                    $where = "(taller.idusuario = {$idusuario}) AND (idestatus = 1 OR idestatus = 2 OR idestatus = 3 )";
                                } else {
                                    $where = "(reporte.idusrtecnico = {$idusuario}) AND (idestatus = 1 OR idestatus = 2 OR idestatus = 3 )";
                                }
                                
                                $query = ""
                                        . "SELECT "
                                        . "ciudad.nombreciudad, ciudad.idciudad, "
                                        . "tiposervicio.idtiposervicio, tiposervicio.nombreservicio, "
                                        . "modelo.idmodelo, modelo.nombremodelo, clasificacion.idclasificacion, "
                                        . "clasificacion.nombreclasificacion, reporte.horaatencion, "
                                        . "reporte.idreporte, corporativo.sla, "
                                        . "reporte.diagnostico, reporte.diasatencion, "
                                        . "reporte.horatermino, reporte.idestatus, reporte.folio, reporte.fechacreacion, "
                                        . "reporte.falla, subclasificacion.nomsubclf, reporte.fechacierre, reporte.longitud, "
                                        . "reporte.latitud, reporte.nompv, reporte.callepv, reporte.nexteriorpv, reporte.ninteriorpv, "
                                        . "reporte.coloniapv, reporte.entrecalleuno, reporte.entrecalledos, reporte.referenciapv, "
                                        . "reporte.nomcliente, reporte.apecliente, reporte.celularcliente, reporte.telefonocliente, "
                                        . "reporte.correocliente "
                                        . "FROM "
                                        . "reporte "
                                        . "LEFT JOIN "
                                        . "ciudad ON "
                                        . "reporte.idciudad = ciudad.idciudad "
                                        . "LEFT JOIN "
                                        . "tiposervicio ON reporte.idtiposervicio = tiposervicio.idtiposervicio "
                                        . "LEFT JOIN "
                                        . "modelo ON reporte.idmodelo = modelo.idmodelo "
                                        . "LEFT JOIN "
                                        . "subclasificacion on reporte.idsubclf = subclasificacion.idsubclasificacion "
                                        . "LEFT JOIN "
                                        . "clasificacion on subclasificacion.idclasificacion = clasificacion.idclasificacion "
                                        . "LEFT JOIN "
                                        . "corporativo on reporte.idcorporativo = corporativo.idcorporativo "
                                        . "LEFT JOIN "
                                        . "taller ON "
                                        . "taller.idtaller = reporte.idusrtaller "
                                        . "WHERE {$where} "
                                        . "ORDER BY reporte.idreporte DESC LIMIT $pagina, 15";
                            } else if ($idrol == 5) {
                                $query = ""
                                        . "SELECT "
                                        . "ciudad.nombreciudad, ciudad.idciudad, "
                                        . "tiposervicio.idtiposervicio, tiposervicio.nombreservicio, "
                                        . "modelo.idmodelo, modelo.nombremodelo, clasificacion.idclasificacion, "
                                        . "clasificacion.nombreclasificacion, reporte.horaatencion, "
                                        . "reporte.idreporte, corporativo.sla, "
                                        . "reporte.diagnostico, reporte.diasatencion, "
                                        . "reporte.horatermino, reporte.idestatus, reporte.folio, reporte.fechacreacion, "
                                        . "reporte.falla, subclasificacion.nomsubclf, reporte.fechacierre, reporte.longitud, "
                                        . "reporte.latitud, reporte.nompv, reporte.callepv, reporte.nexteriorpv, reporte.ninteriorpv, "
                                        . "reporte.coloniapv, reporte.entrecalleuno, reporte.entrecalledos, reporte.referenciapv, "
                                        . "reporte.nomcliente, reporte.apecliente, reporte.celularcliente, reporte.telefonocliente, "
                                        . "reporte.correocliente "
                                        . "FROM "
                                        . "reporte "
                                        . "LEFT JOIN "
                                        . "ciudad ON "
                                        . "reporte.idciudad = ciudad.idciudad "
                                        . "LEFT JOIN "
                                        . "tiposervicio ON reporte.idtiposervicio = tiposervicio.idtiposervicio "
                                        . "LEFT JOIN "
                                        . "modelo ON reporte.idmodelo = modelo.idmodelo "
                                        . "LEFT JOIN "
                                        . "subclasificacion on reporte.idsubclf = subclasificacion.idsubclasificacion "
                                        . "LEFT JOIN "
                                        . "clasificacion on subclasificacion.idclasificacion = clasificacion.idclasificacion "
                                        . "LEFT JOIN "
                                        . "corporativo on reporte.idcorporativo = corporativo.idcorporativo "
                                        . "WHERE {$where} "
                                        . "AND corporativo.idusuario = {$idusuario} "
                                        . "ORDER BY reporte.idreporte DESC LIMIT $pagina, 15";
                            } else if ($idrol == 6) {
                                
                            }

                            $db = $em->getConnection();
                            $stmt = $db->prepare($query);

                            $params = array();

                            $stmt->execute($params);

                            $reportes = $stmt->fetchAll();

                            if (count($reportes) != 0) {

                                $data = array(
                                    "status" => "succes!!",
                                    "code" => 200,
                                    "msg" => "reportes encontrados!!",
                                    "reportes" => $reportes
                                );
                            } else {
                                if($pagina > 0) {
                                    $data = array(
                                    "status" => "error",
                                    "code" => 401,
                                    "msg" => "Son todos los reportes!!"
                                );
                                } else {
                                    $data = array(
                                    "status" => "error",
                                    "code" => 400,
                                    "msg" => "no hay reportes!!"
                                );
                                }
                                
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }

    public function detalleAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) { //si el usuario existe entra
                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            $json = $request->get("json", null);

                            if ($json != null) {

                                $params = json_decode($json);

                                $idreporte = ( $params->idreporte != null ) ? $params->idreporte : null;

                                $query = "SELECT * FROM "
                                        . "reporte "
                                        . "LEFT JOIN "
                                        . "ciudad on ciudad.idciudad = reporte.idciudad "
                                        . "LEFT JOIN estado on estado.idestado = ciudad.idestado "
                                        . "LEFT JOIN zona on estado.idzona = zona.idzona "
                                        . "WHERE idreporte = {$idreporte}";

                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $reportes = $stmt->fetchAll();

                                if (count($reportes) != 0) {


                                    $tecnico = intval($reportes[0]["idusrtecnico"]);
                                    $idusroperador = intval($reportes[0]["idusroperador"]);
                                    $idtaller = intval($reportes[0]["idusrtaller"]);
                                    $corporativo = intval($reportes[0]["idcorporativo"]);
                                    $clasificacion = intval($reportes[0]["idsubclf"]);
                                    $estatus = intval($reportes[0]["idestatus"]);
                                    $servicio = intval($reportes[0]["idtiposervicio"]);

                                    $idusroperador = intval($reportes[0]["idusroperador"]);

                                    $query = "SELECT * FROM "
                                            . "usuario "
                                            . "WHERE idusuario = {$idusroperador}";


                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $usroperador = $stmt->fetchAll();

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "Solo reportes!!",
                                        "reporte" => $reportes,
                                        "operador" => $usroperador
                                    );

                                    if ($estatus != null) {
                                        $querytaller = "SELECT * FROM estatus WHERE idestatus = {$estatus}";

                                        $stm = $db->prepare($querytaller);

                                        $params = array();

                                        $stm->execute($params);

                                        $estatus = $stm->fetchAll();

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "Solo reportes!!",
                                            "reporte" => $reportes,
                                            "estatus" => $estatus,
                                            "operador" => $usroperador
                                        );
                                    }

                                    if ($servicio != null) {
                                        $querytaller = "SELECT * FROM tiposervicio WHERE idtiposervicio = {$servicio}";

                                        $stm = $db->prepare($querytaller);

                                        $params = array();

                                        $stm->execute($params);

                                        $servicio = $stm->fetchAll();

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "Solo reportes!!",
                                            "reporte" => $reportes,
                                            "estatus" => $estatus,
                                            "servicio" => $servicio,
                                            "operador" => $usroperador
                                        );
                                    }

                                    if ($corporativo != null) {
                                        $querytaller = "SELECT * FROM corporativo WHERE idcorporativo = {$corporativo}";

                                        $stm = $db->prepare($querytaller);

                                        $params = array();

                                        $stm->execute($params);

                                        $corporativo = $stm->fetchAll();

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "Solo reportes!!",
                                            "reporte" => $reportes,
                                            "corporativo" => $corporativo,
                                            "estatus" => $estatus,
                                            "servicio" => $servicio,
                                            "operador" => $usroperador
                                        );



                                        if ($idtaller != null) {

                                            $querytaller = "SELECT * FROM taller "
                                                    . "LEFT JOIN "
                                                    . "ciudad on ciudad.idciudad = taller.idciudad "
                                                    . "WHERE idtaller = {$idtaller}";

                                            $stm = $db->prepare($querytaller);

                                            $params = array();

                                            $stm->execute($params);

                                            $taller = $stm->fetchAll();

                                            $data = array(
                                                "status" => "succes!!",
                                                "code" => 201,
                                                "msg" => "Solo reportes!!",
                                                "reporte" => $reportes,
                                                "taller" => $taller,
                                                "corporativo" => $corporativo,
                                                "estatus" => $estatus,
                                                "servicio" => $servicio,
                                                "operador" => $usroperador
                                            );

                                            if ($tecnico != null) {

                                                $querytaller = "SELECT * FROM "
                                                        . "usuario "
                                                        . "WHERE idusuario = {$tecnico}";

                                                $stm = $db->prepare($querytaller);

                                                $params = array();

                                                $stm->execute($params);

                                                $tecnico = $stm->fetchAll();

                                                $data = array(
                                                    "status" => "succes!!",
                                                    "code" => 202,
                                                    "msg" => "Solo reportes!!",
                                                    "reporte" => $reportes,
                                                    "taller" => $taller,
                                                    "tecnico" => $tecnico,
                                                    "corporativo" => $corporativo,
                                                    "estatus" => $estatus,
                                                    "servicio" => $servicio,
                                                    "operador" => $usroperador
                                                );

                                                if ($clasificacion != null) {

                                                    $auxclf = $clasificacion;
                                                    $querytaller = ""
                                                            . "SELECT "
                                                            . "subclasificacion.idsubclasificacion, subclasificacion.nomsubclf, "
                                                            . "clasificacion.idclasificacion, clasificacion.nombreclasificacion "
                                                            . "FROM "
                                                            . "subclasificacion "
                                                            . "LEFT JOIN "
                                                            . "clasificacion on subclasificacion.idclasificacion = clasificacion.idclasificacion "
                                                            . "WHERE "
                                                            . "subclasificacion.idsubclasificacion = {$clasificacion}";

                                                    $stm = $db->prepare($querytaller);

                                                    $params = array();

                                                    $stm->execute($params);

                                                    $clasificacion = $stm->fetchAll();

                                                    $data = array(
                                                        "status" => "succes!!",
                                                        "code" => 203,
                                                        "msg" => "Solo reportes!!",
                                                        "reporte" => $reportes,
                                                        "corporativo" => $corporativo,
                                                        "taller" => $taller,
                                                        "tecnico" => $tecnico,
                                                        "clasificacion" => $clasificacion,
                                                        "estatus" => $estatus,
                                                        "servicio" => $servicio,
                                                        "operador" => $usroperador
                                                    );

                                                    if ($auxclf == 1 || $auxclf == 2) {

                                                        $querytaller = ""
                                                                . "SELECT "
                                                                . "detallerefacciones.cantidad, modelo.idmodelo, modelo.nombremodelo, "
                                                                . "refaccion.nombrerefaccion, refaccion.idrefaccion, "
                                                                . "servicio.nombreservicio, servicio.idservicio "
                                                                . "FROM "
                                                                . "detallerefacciones "
                                                                . "LEFT JOIN "
                                                                . "almacen on detallerefacciones.idrefaccion = almacen.idrefaccion "
                                                                . "LEFT JOIN "
                                                                . "refaccion on refaccion.idrefaccion = almacen.idrefaccion "
                                                                . "LEFT JOIN "
                                                                . "modelo on modelo.idmodelo = refaccion.idmodelo "
                                                                . "LEFT JOIN "
                                                                . "servicio on servicio.idservicio = refaccion.idservicio "
                                                                . "WHERE "
                                                                . "idreporte = {$idreporte}";
                                                        $stm = $db->prepare($querytaller);

                                                        $params = array();

                                                        $stm->execute($params);

                                                        $refacciones = $stm->fetchAll();

                                                        if (count($refacciones) != 0) {
                                                            $data = array(
                                                                "status" => "succes!!",
                                                                "code" => 204,
                                                                "msg" => "Solo reportes!!",
                                                                "reporte" => $reportes,
                                                                "taller" => $taller,
                                                                "tecnico" => $tecnico,
                                                                "corporativo" => $corporativo,
                                                                "estatus" => $estatus,
                                                                "clasificacion" => $clasificacion,
                                                                "refacciones" => $refacciones,
                                                                "servicio" => $servicio,
                                                                "operador" => $usroperador
                                                            );
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "no hay reportes!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }

     public function insertAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {

            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            if ($idrol == 2 || $idrol == 1) {

                                $json = $request->get("json", null);

                                if ($json != null) {
                                    $params = json_decode($json);

                                    $comentarios = ( $params->Comentarios != null ) ? $params->Comentarios : null;
                                    $apecliente = ( $params->apecliente != null ) ? $params->apecliente : null;
                                    $callepv = ( $params->callepv != null ) ? $params->callepv : null;
                                    $celularcliente = ( $params->celularcliente != null ) ? $params->celularcliente : null;
                                    $coloniapv = ( $params->coloniapv != null ) ? $params->coloniapv : null;
                                    $correocliente = ( $params->correocliente != null ) ? $params->correocliente : null;
                                    $correopv = ( $params->correopv != null ) ? $params->correopv : null;
                                    $correocliente = ( $params->correocliente != null ) ? $params->correocliente : null;
                                    $detalle = ( $params->detalle != null ) ? $params->detalle : null;
                                    $diasatencion = ( $params->diasatencion != null ) ? $params->diasatencion : null;
                                    $entrecalleuno = ( $params->entrecalleuno != null ) ? $params->entrecalleuno : null;
                                    $entrecalledos = ( $params->entrecalledos != null ) ? $params->entrecalledos : null;
                                    $folio = ( $params->folio != null ) ? $params->folio : null;
                                    $horaatencion = ( $params->horaatencion != null ) ? $params->horaatencion : null;
                                    $horatermino = ( $params->horatermino != null ) ? $params->horatermino : null;
                                    $idciudad = ( $params->idciudad != null ) ? $params->idciudad : null;
                                    $idcorporativo = ( $params->idcorporativo != null ) ? $params->idcorporativo : null;
                                    $idtiposervicio = ( $params->idtiposervicio != null ) ? $params->idtiposervicio : null;
                                    $idusroperador = ( $params->idusroperador != null ) ? $params->idusroperador : null;
                                    $nexteriorpv = ( $params->nexteriorpv != null ) ? $params->nexteriorpv : null;
                                    $ninteriorpv = ( $params->ninteriorpv != null ) ? $params->ninteriorpv : null;
                                    $nomcliente = ( $params->nomcliente != null ) ? $params->nomcliente : null;
                                    $nompv = ( $params->nompv != null ) ? $params->nompv : null;
                                    $cp = ( $params->cp != null ) ? $params->cp : null;
                                    $referenciapv = ( $params->referenciapv != null ) ? $params->referenciapv : null;
                                    $telefonocliente = ( $params->telefonocliente != null ) ? $params->telefonocliente : null;

                                    if ($nomcliente != null && $folio != null && $nexteriorpv != null &&
                                            $apecliente != null && $idciudad != null && $idusroperador != null &&
                                            $idcorporativo != null && $idtiposervicio != null) {

                                        $idestatus = 1;

                                        $db = $em->getConnection();

                                        $querybusqueda = "SELECT * FROM reporte WHERE folio = '$folio' ";

                                        $stmt = $db->prepare($querybusqueda);

                                        $params = array();

                                        $stmt->execute($params);

                                        $reportes = $stmt->fetchAll();

                                        if (count($reportes) <= 0) {
                                            $query = "INSERT INTO "
                                                    . "reporte "
                                                    . "(idusroperador, idestatus, idciudad, idcorporativo, nomcliente, apecliente, nompv, telefonocliente, celularcliente, callepv, nexteriorpv, ninteriorpv, coloniapv, entrecalleuno, entrecalledos, referenciapv, detalle, diasatencion, horaatencion, horatermino, idtiposervicio, folio, correocliente, correopv, cp) "
                                                    . "VALUES "
                                                    . "({$idusroperador}, {$idestatus}, {$idciudad}, {$idcorporativo}, '{$nomcliente}', '{$apecliente}', '{$nompv}', '{$telefonocliente}', '{$celularcliente}', '{$callepv}', '{$nexteriorpv}', '{$ninteriorpv}', '{$coloniapv}', '{$entrecalleuno}', '{$entrecalledos}', '{$referenciapv}', '{$detalle}', '{$diasatencion}', '{$horaatencion}', '{$horatermino}', {$idtiposervicio}, '{$folio}', '{$correocliente}', '{$correopv}', {$cp})";


                                            $stmt = $db->prepare($query);
                                            $params = array();
                                            $stmt->execute($params);

                                            $data = array(
                                                "status" => "succes!!",
                                                "code" => 200,
                                                "msg" => "reporte creado!!"
                                            );
                                        } else {
                                            $data = array(
                                                "status" => "ERROR!!",
                                                "code" => 405,
                                                "msg" => "El reporte con este folio ya existe!!"
                                            );
                                        }
                                    } else {
                                        $data = array(
                                            "status" => "error!!",
                                            "code" => 400,
                                            "msg" => " faltan dato!!"
                                        );
                                    }
                                } else {

                                    $data = array(
                                        "status" => "error!!",
                                        "code" => 400,
                                        "msg" => " faltan dato!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error!!",
                "code" => 400,
                "msg" => " error con el servidor!!"
            );
        }

        return $helpers->json($data);
    }

    //FUNCION PARA DESIGANAR UN TALLER O UN TECNICO A UN REPORTE
    public function updatetallerAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {

            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            if ($idrol == 2 || $idrol == 1 || $idrol == 3) {

                                $json = $request->get("json", null);

                                if ($json != null) {
                                    $params = json_decode($json);

                                    $tipo = ( $params->tipo != null ) ? $params->tipo : null;
                                    $idreporte = ( $params->idreporte != null ) ? $params->idreporte : null;

                                    if ($tipo != null && $idreporte != null) {

                                        $updateid = " ";
                                        $idestatus = 1;

                                        if ($tipo == 1 && ($idrol == 2 || $idrol == 1)) {
                                            $idusrtaller = ( $params->idusrtecnico != null ) ? $params->idusrtecnico : null;

                                            if ($idusrtaller != null) {
                                                $updateid = "idusrtaller = {$idusrtaller}";
                                                $idestatus = 2;
                                            }
                                        } else if ($tipo == 2) {
                                            $idusrtecnico = ( $params->idusrtecnico != null ) ? $params->idusrtecnico : null;
                                            if ($idusrtecnico != null) {
                                                $updateid = "idusrtecnico = {$idusrtecnico}";
                                                $idestatus = 3;
                                            }
                                        }


                                        if ($idestatus != 1) {
                                            $db = $em->getConnection();
                                            $query = "UPDATE "
                                                    . "reporte "
                                                    . "SET {$updateid} , idestatus = {$idestatus} "
                                                    . "WHERE "
                                                    . "idreporte = {$idreporte}";

                                            $stmt = $db->prepare($query);
                                            $params = array();
                                            $stmt->execute($params);

                                            $data = array(
                                                "status" => "succes!!",
                                                "code" => 200,
                                                "msg" => "dato actualizado!!"
                                            );
                                        } else {
                                            $data = array(
                                                "status" => "succes!!",
                                                "code" => 400,
                                                "msg" => "dato no actualizado!!"
                                            );
                                        }
                                    } else {
                                        $data = array(
                                            "status" => "error!!",
                                            "code" => 400,
                                            "msg" => " faltan dato!!"
                                        );
                                    }
                                } else {

                                    $data = array(
                                        "status" => "error!!",
                                        "code" => 400,
                                        "msg" => " faltan dato!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error!!",
                "code" => 400,
                "msg" => " error con el servidor!!"
            );
        }

        return $helpers->json($data);
    }

    public function updatereportetecnicoAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {

            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            if ($idrol == 2 || $idrol == 1 || $idrol == 4) {

                                $json = $request->get("json", null);

                                if ($json != null) {
                                    $params = json_decode($json);

                                    $idreporte = ( $params->idreporte != null ) ? $params->idreporte : null;
                                    $diagnostico = ( $params->diagnostico != null ) ? $params->diagnostico : null;
                                    $falla = ( $params->falla != null ) ? $params->falla : null;
                                    $nserie = ( $params->nserie != null ) ? $params->nserie : null;
                                    $nactivo = ( $params->nactivo != null ) ? $params->nactivo : null;
                                    $idclasificacion = ( $params->idclasificacion != null ) ? $params->idclasificacion : null;
                                    $idsubclasificacion = ( $params->idsubclasificacion != null ) ? $params->idsubclasificacion : null;
                                    $latitud = ( $params->latitud != null ) ? $params->latitud : null;
                                    $longitud = ( $params->longitud != null ) ? $params->longitud : null;

                                    if ($idreporte != null && $idsubclasificacion != null && $idclasificacion != null) {

                                        if($idclasificacion == 3 || $idclasificacion == 4 || $idclasificacion == 5 || $idclasificacion == 6){
                                            $idestatus = 5;
                                        } else {
                                            $idestatus = 4;
                                        }
                                        
                                        date_default_timezone_set('America/Mexico_City');
                                        setlocale(LC_TIME, 'es_MX.UTF-8');
                                        $fecha_actual=strftime("%Y-%m-%d");
                                        $hora_actual=strftime("%H:%M:%S");
                                        
                                        $fechacierre = "$fecha_actual $hora_actual";
                                        
                                        /*$fecha = date_create();
                                        $fechacierre = $fecha->format('Y-m-d H:i:s');*/

                                        $updateid = "fechacierre = '{$fechacierre}',diagnostico='{$diagnostico}', falla='{$falla}', nserieequipo='{$nserie}', nactivo='{$nactivo}', idsubclf={$idsubclasificacion}, latitud='{$latitud}', longitud='{$longitud}'";

                                        $db = $em->getConnection();
                                        $query = "UPDATE "
                                                . "reporte "
                                                . "SET {$updateid} , idestatus = {$idestatus} "
                                                . "WHERE "
                                                . "idreporte = {$idreporte}";

                                        $stmt = $db->prepare($query);
                                        $params = array();
                                        $stmt->execute($params);

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "dato actualizado!!"
                                        );
                                    } else {
                                        $data = array(
                                            "status" => "error!!",
                                            "code" => 400,
                                            "msg" => " faltan dato!!"
                                        );
                                    }
                                } else {

                                    $data = array(
                                        "status" => "error!!",
                                        "code" => 400,
                                        "msg" => " faltan dato!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error!!",
                "code" => 400,
                "msg" => " error con el servidor!!"
            );
        }

        return $helpers->json($data);
    }
   
    public function selectfolioAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            $json = $request->get("json", null);

                            $jsondecode = json_decode($json);

                            $folio = ( $jsondecode->folio != null ) ? $jsondecode->folio : null;


                            $where = ""; //variable del where para la busqueda de reportes por estatus
                            //var_dump($pagina);
                            if ($idrol == 1 || $idrol == 2) {

                                $query = ""
                                        . "SELECT "
                                        . "ciudad.nombreciudad, ciudad.idciudad, "
                                        . "tiposervicio.idtiposervicio, tiposervicio.nombreservicio, "
                                        . "modelo.idmodelo, modelo.nombremodelo, clasificacion.idclasificacion, "
                                        . "clasificacion.nombreclasificacion, reporte.horaatencion, "
                                        . "reporte.idreporte, corporativo.sla, "
                                        . "reporte.diagnostico, reporte.diasatencion, "
                                        . "reporte.horatermino, reporte.idestatus, reporte.folio, reporte.fechacreacion, "
                                        . "reporte.falla, subclasificacion.nomsubclf, reporte.fechacierre, reporte.longitud, "
                                        . "reporte.latitud, reporte.nompv, reporte.callepv, reporte.nexteriorpv, reporte.ninteriorpv, "
                                        . "reporte.coloniapv, reporte.entrecalleuno, reporte.entrecalledos, reporte.referenciapv, "
                                        . "reporte.nomcliente, reporte.apecliente, reporte.celularcliente, reporte.telefonocliente, "
                                        . "reporte.correocliente "
                                        . "FROM "
                                        . "reporte "
                                        . "LEFT JOIN "
                                        . "ciudad ON "
                                        . "reporte.idciudad = ciudad.idciudad "
                                        . "LEFT JOIN "
                                        . "tiposervicio ON reporte.idtiposervicio = tiposervicio.idtiposervicio "
                                        . "LEFT JOIN "
                                        . "modelo ON reporte.idmodelo = modelo.idmodelo "
                                        . "LEFT JOIN "
                                        . "subclasificacion on reporte.idsubclf = subclasificacion.idsubclasificacion "
                                        . "LEFT JOIN "
                                        . "clasificacion on subclasificacion.idclasificacion = clasificacion.idclasificacion "
                                        . "LEFT JOIN "
                                        . "corporativo on reporte.idcorporativo = corporativo.idcorporativo "
                                        . "WHERE {$where} "
                                        . "reporte.folio = '{$folio}'";
                            } else if ($idrol == 3 || $idrol == 4) {

                                $where = "";
                                if ($idrol == 3) {
                                    $where = "taller.idusuario = {$idusuario}";
                                } else {
                                    $where = "reporte.idusrtecnico = {$idusuario}";
                                }

                                $query = ""
                                        . "SELECT "
                                        . "ciudad.nombreciudad, ciudad.idciudad, "
                                        . "tiposervicio.idtiposervicio, tiposervicio.nombreservicio, "
                                        . "modelo.idmodelo, modelo.nombremodelo, clasificacion.idclasificacion, "
                                        . "clasificacion.nombreclasificacion, reporte.horaatencion, "
                                        . "reporte.idreporte, corporativo.sla, "
                                        . "reporte.diagnostico, reporte.diasatencion, "
                                        . "reporte.horatermino, reporte.idestatus, reporte.folio, reporte.fechacreacion, "
                                        . "reporte.falla, subclasificacion.nomsubclf, reporte.fechacierre, reporte.longitud, "
                                        . "reporte.latitud, reporte.nompv, reporte.callepv, reporte.nexteriorpv, reporte.ninteriorpv, "
                                        . "reporte.coloniapv, reporte.entrecalleuno, reporte.entrecalledos, reporte.referenciapv, "
                                        . "reporte.nomcliente, reporte.apecliente, reporte.celularcliente, reporte.telefonocliente, "
                                        . "reporte.correocliente "
                                        . "FROM "
                                        . "reporte "
                                        . "LEFT JOIN "
                                        . "ciudad ON "
                                        . "reporte.idciudad = ciudad.idciudad "
                                        . "LEFT JOIN "
                                        . "tiposervicio ON reporte.idtiposervicio = tiposervicio.idtiposervicio "
                                        . "LEFT JOIN "
                                        . "modelo ON reporte.idmodelo = modelo.idmodelo "
                                        . "LEFT JOIN "
                                        . "subclasificacion on reporte.idsubclf = subclasificacion.idsubclasificacion "
                                        . "LEFT JOIN "
                                        . "clasificacion on subclasificacion.idclasificacion = clasificacion.idclasificacion "
                                        . "LEFT JOIN "
                                        . "corporativo on reporte.idcorporativo = corporativo.idcorporativo "
                                        . "LEFT JOIN "
                                        . "taller ON "
                                        . "taller.idtaller = reporte.idusrtaller "
                                        . "WHERE {$where} "
                                        . "AND reporte.folio = '{$folio}'";
                            } else if ($idrol == 5) {
                                $query = ""
                                        . "SELECT "
                                        . "ciudad.nombreciudad, ciudad.idciudad, "
                                        . "tiposervicio.idtiposervicio, tiposervicio.nombreservicio, "
                                        . "modelo.idmodelo, modelo.nombremodelo, clasificacion.idclasificacion, "
                                        . "clasificacion.nombreclasificacion, reporte.horaatencion, "
                                        . "reporte.idreporte, corporativo.sla, "
                                        . "reporte.diagnostico, reporte.diasatencion, "
                                        . "reporte.horatermino, reporte.idestatus, reporte.folio, reporte.fechacreacion, "
                                        . "reporte.falla, subclasificacion.nomsubclf, reporte.fechacierre, reporte.longitud, "
                                        . "reporte.latitud, reporte.nompv, reporte.callepv, reporte.nexteriorpv, reporte.ninteriorpv, "
                                        . "reporte.coloniapv, reporte.entrecalleuno, reporte.entrecalledos, reporte.referenciapv, "
                                        . "reporte.nomcliente, reporte.apecliente, reporte.celularcliente, reporte.telefonocliente, "
                                        . "reporte.correocliente "
                                        . "FROM "
                                        . "reporte "
                                        . "LEFT JOIN "
                                        . "ciudad ON "
                                        . "reporte.idciudad = ciudad.idciudad "
                                        . "LEFT JOIN "
                                        . "tiposervicio ON reporte.idtiposervicio = tiposervicio.idtiposervicio "
                                        . "LEFT JOIN "
                                        . "modelo ON reporte.idmodelo = modelo.idmodelo "
                                        . "LEFT JOIN "
                                        . "subclasificacion on reporte.idsubclf = subclasificacion.idsubclasificacion "
                                        . "LEFT JOIN "
                                        . "clasificacion on subclasificacion.idclasificacion = clasificacion.idclasificacion "
                                        . "LEFT JOIN "
                                        . "corporativo on reporte.idcorporativo = corporativo.idcorporativo "
                                        . "WHERE {$where} "
                                        . "corporativo.idusuario = {$idusuario} "
                                        . "AND reporte.folio = '{$folio}'";
                            }

                            $db = $em->getConnection();
                            $stmt = $db->prepare($query);

                            $params = array();

                            $stmt->execute($params);

                            $reportes = $stmt->fetchAll();

                            if (count($reportes) != 0) {

                                $data = array(
                                    "status" => "succes!!",
                                    "code" => 200,
                                    "msg" => "reportes encontrados!!",
                                    "reportes" => $reportes
                                );
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 402,
                                    "msg" => "no hay reportes!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function uploadImageAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $file = $request->files->get("image");
                            if (!empty($file) && $file != null) {
                                $ext = $file->guessExtension(); //obtenemos la extencion
                                if ( $ext == "jpeg" || $ext == "jpg" ) {
                                    
                                    $file_name = time() . "." . $ext; //le asignamos un nombre diferente
                                    $file->move("uploads/reporte", $file_name); //subir al fichero
                                    ///aqui va el insert sql
                                    
                                    $json = $request->get("json", null);
                                    $jsondecode = json_decode($json);
                                    $idreporte = ( $jsondecode->idreporte != null ) ? $jsondecode->idreporte : null;
                                    $foto = ( $jsondecode->foto != null ) ? $jsondecode->foto : null;
                                    
                                    $query = "";
                                    if ($foto == 1) {
                                         $query = "SET fotouno = 'https://apiitc.itcdemexico.com/suportapi/web/uploads/reporte/{$file_name}'";
                                    }
                                    if ($foto == 2) {
                                         $query = "SET fotodos = 'https://apiitc.itcdemexico.com/suportapi/web/uploads/reporte/{$file_name}'";
                                    }
                                    if ($foto == 3) {
                                         $query = "SET fototres = 'https://apiitc.itcdemexico.com/suportapi/web/uploads/reporte/{$file_name}'";
                                    }
                                    
                                    $query = "UPDATE reporte {$query} "
                                            . "WHERE idreporte = {$idreporte}";

                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "Imagenes cargadas correctamente!!"
                                    );
                                } else {
                                    $data = array(
                                    "status" => "error",
                                    "code" => 402,
                                    "msg" => "ERROR DE ARCHIVO!!"
                                );
                                }
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 401,
                                    "msg" => "erro al cargar imagenes!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function uploadEvidenciaAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            //$file = $request->files->get("image");
                            
                             $json = $request->get("json", null);
                             
                            if ($json != null) {
            
                                    $jsondecode = json_decode($json);
                                    
                                    $idreporte = ( $jsondecode->idreporte != null ) ? $jsondecode->idreporte : null;
                                    $imagen = ( $jsondecode->imagen != null ) ? $jsondecode->imagen : null;
                                    $foto = ( $jsondecode->foto != null ) ? $jsondecode->foto : null;
                                    
                                    $imagendata = str_replace("data:image/jpeg;base64,","",$imagendata);
                                    $imagendata = str_replace("data:image/jpg;base64,","",$imagendata);
                                    $imagendata = str_replace(" ", "+", $imagendata);
                                    
                                    $file_name = time().'jpg';
                                    
                                    file_put_contents($file_name, $imagendata);
                                    $query = "";
                                    if ($foto == 1) {
                                         $query = "SET fotouno = 'https://apiitc.itcdemexico.com/suportapi/web/uploads/reporte/{$file_name}'";
                                    }
                                    if ($foto == 2) {
                                         $query = "SET fotodos = 'https://apiitc.itcdemexico.com/suportapi/web/uploads/reporte/{$file_name}'";
                                    }
                                    if ($foto == 3) {
                                         $query = "SET fototres = 'https://apiitc.itcdemexico.com/suportapi/web/uploads/reporte/{$file_name}'";
                                    }
                                    
                                    $query = "UPDATE reporte {$query} "
                                            . "WHERE idreporte = {$idreporte}";

                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "Imagenes cargadas correctamente!!"
                                    );
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 401,
                                    "msg" => "erro al cargar imagenes!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function busquedainteligenteAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            if ($idrol == 1 || $idrol == 2) {

                                $json = $request->get("json", null);
                                $wheresql = "";
                                if ($json != null) {
                                    $jsondecode = json_decode($json);
                                    $fechainicio = ( $jsondecode->fechainicio != null ) ? $jsondecode->fechainicio : null;
                                    $fechatermino = ( $jsondecode->fechatermino != null ) ? $jsondecode->fechatermino : null;

                                    $idreporte = ( $jsondecode->idreporte != null ) ? $jsondecode->idreporte : null;
                                    $folio = ( $jsondecode->folio != null ) ? $jsondecode->folio : null;

                                    $idciudad = ( $jsondecode->idciudad != null ) ? $jsondecode->idciudad : null;
                                    $idt = ( $jsondecode->idtaller != null ) ? $jsondecode->idtaller : null;
                                    $idcorporativo = ( $jsondecode->idcorporativo != null ) ? $jsondecode->idcorporativo : null;
                                    $idestatus = ( $jsondecode->idestatus != null ) ? $jsondecode->idestatus : null;
                                    $idestado = ( $jsondecode->idestado != null ) ? $jsondecode->idestado : null;
                                    $idzona = ( $jsondecode->idzona != null ) ? $jsondecode->idzona : null;
                                    $idtiposervicio = ( $jsondecode->idtiposervicio != null ) ? $jsondecode->idtiposervicio : null;
                                    $idusrtecnico = ( $jsondecode->idusrtecnico != null ) ? $jsondecode->idusrtecnico : null;
                                    $idsubclasificacion = ( $jsondecode->idsubclasificacion != null ) ? $jsondecode->idsubclasificacion : null;

                                    if ($fechainicio != null && $fechatermino != null) {
                                        
                                        $wheresql = "WHERE reporte.fechacreacion >= '{$fechainicio}' and reporte.fechacreacion <= '{$fechatermino}'";

                                        if ($idciudad != null || $idt != null ||
                                                $idcorporativo != null || $idestatus != null || $idestado != null || $idzona != null ||
                                                $idtiposervicio != null || $idusrtecnico != null || $idsubclasificacion != null) {
                                            
                                            $wheresql = " {$wheresql} AND ";

                                            if ($idciudad != null) {
                                                
                                                $wheresql = " {$wheresql} reporte.idciudad = {$idciudad} ";
                                                        
                                                if($idt != null ||$idcorporativo != null || 
                                                        $idestatus != null || $idestado != null || $idzona != null ||$idtiposervicio != null || 
                                                        $idusrtecnico != null || $idsubclasificacion != null){
                                                    
                                                    $wheresql = " {$wheresql} AND ";
                                                }
                                            }
                                            if ($idt != null) {
                                                
                                                $wheresql = " {$wheresql} reporte.idusrtaller = {$idt} ";
                                                        
                                                if($idcorporativo != null || 
                                                        $idestatus != null || $idestado != null || $idzona != null ||$idtiposervicio != null || 
                                                        $idusrtecnico != null || $idsubclasificacion != null){
                                                    
                                                    $wheresql = " {$wheresql} AND ";
                                                }
                                            }
                                            if ($idcorporativo != null) {
                                                
                                                $wheresql = " {$wheresql} reporte.idcorporativo = {$idcorporativo} ";
                                                        
                                                if($idestatus != null || $idestado != null || $idzona != null ||$idtiposervicio != null || 
                                                        $idusrtecnico != null || $idsubclasificacion != null){
                                                    
                                                    $wheresql = " {$wheresql} AND ";
                                                }
                                            }
                                            if ($idestado != null) {
                                                
                                                $wheresql = " {$wheresql} estado.idestado = {$idestado} ";
                                                        
                                                if($idestatus != null || $idzona != null ||$idtiposervicio != null || 
                                                        $idusrtecnico != null || $idsubclasificacion != null){
                                                    
                                                    $wheresql = " {$wheresql} AND ";
                                                }
                                            }
                                            if ($idzona != null) {
                                                
                                                $wheresql = " {$wheresql} zona.idzona = {$idzona} ";
                                                        
                                                if($idestatus != null || $idtiposervicio != null || 
                                                        $idusrtecnico != null || $idsubclasificacion != null){
                                                    
                                                    $wheresql = " {$wheresql} AND ";
                                                }
                                            }
                                            if ($idtiposervicio != null) {
                                                
                                                $wheresql = " {$wheresql} reporte.idtiposervicio = {$idtiposervicio} ";
                                                        
                                                if($idestatus != null || $idusrtecnico != null || $idsubclasificacion != null){
                                                    
                                                    $wheresql = " {$wheresql} AND ";
                                                }
                                            }
                                            
                                            if ($idusrtecnico != null) {
                                                
                                                $wheresql = " {$wheresql} reporte.idusrtecnico = {$idusrtecnico} ";
                                                        
                                                if($idestatus != null || $idsubclasificacion != null){
                                                    
                                                    $wheresql = " {$wheresql} AND ";
                                                }
                                            }
                                            if ($idsubclasificacion != null) {
                                                $wheresql = " {$wheresql} reporte.idsubclasificacion = {$idsubclasificacion} ";
                                                if($idestatus != null){
                                                    
                                                    $wheresql = " {$wheresql} AND ";
                                                }
                                            }
                                            if ($idestatus != null) {
                                                $wheresql = " {$wheresql} reporte.idestatus = {$idestatus} ";
                                            }
                                        }
                                    }
                                    if($idreporte != null) {
                                        $wheresql = "WHERE reporte.idreporte = {$idreporte}";
                                    }
                                    if($folio != null) {
                                        $wheresql = "WHERE reporte.folio = '{$folio}'";
                                    }
                                    
                                    /*if($idestatus != null) {
                                        $wheresql = " {$wheresql} AND reporte.idestatus = {$idestatus}";
                                    }*/

                                    //$wheresql = "WHERE reporte.fechacreacion >= '{$fechainicio}' and reporte.fechacreacion <= '{$fechatermino}'";
                                }

                                $query = "SELECT "
                                        . ""
                                        . "reporte.folio, reporte.idreporte, reporte.idusrtecnico, reporte.idestatus, "
                                        . "reporte.idcorporativo, reporte.idsubclf, reporte.fechacreacion, reporte.fechacierre, reporte.nomcliente, reporte.apecliente, "
                                        . "reporte.nompv, reporte.telefonocliente, reporte.celularcliente, reporte.callepv, reporte.nexteriorpv, reporte.ninteriorpv, "
                                        . "reporte.coloniapv, reporte.entrecalleuno, reporte.entrecalledos, reporte.referenciapv, reporte.falla, reporte.detalle, "
                                        . "reporte.latitud, reporte.longitud, reporte.diasatencion, reporte.horaatencion, reporte.nserieequipo, reporte.diagnostico, reporte.horatermino, "
                                        . "reporte.idtiposervicio, reporte.Comentarios, reporte.idmodelo, reporte.correocliente, reporte.correopv, reporte.nactivo, reporte.cp, "
                                        . ""
                                        . "usuario.idusuario, usuario.nombres as nombreoperador, usuario.apellidos as apellidosoperador, usuario.correo as correooperador, "
                                        . "usuario.rfc as rfcoperador, usuario.telefono as telefonooperador, usuario.celular as celularoperador, "
                                        . ""
                                        . "ciudad.idciudad as idciudadreporte, ciudad.nombreciudad as nomciudadreporte, "
                                        . ""
                                        . "estado.idestado as idestadoreporte, nombreestado as nomestadoreporte, "
                                        . ""
                                        . "zona.idzona as idzonareporte, zona.nombrezona as nomzonareporte, "
                                        . ""
                                        . "estatus.idestatus, estatus.nombreestatus, "
                                        . ""
                                        . "corporativo.idcorporativo, corporativo.nomcorporativo, corporativo.sla, "
                                        . ""
                                        . "subclasificacion.idsubclasificacion as idsubclasificacion, subclasificacion.nomsubclf as nomsubclasificacion, "
                                        . ""
                                        . "clasificacion.idclasificacion, clasificacion.nombreclasificacion, "
                                        . ""
                                        . "tiposervicio.idtiposervicio, tiposervicio.nombreservicio, "
                                        . ""
                                        . "taller.idtaller, taller.idusuario as idencargadotaller, taller.idciudad as idciudadtaller, "
                                        . "taller.nombrecomercial, taller.cptaller, taller.celulartaller, taller.correotaller "
                                        . ""
                                        . "FROM "
                                        . "reporte "
                                        . "LEFT JOIN "
                                        . "usuario on reporte.idusroperador = usuario.idusuario "
                                        . "LEFT JOIN "
                                        . "ciudad on ciudad.idciudad = reporte.idciudad "
                                        . "LEFT JOIN "
                                        . "estado on estado.idestado = ciudad.idestado "
                                        . "LEFT JOIN "
                                        . "zona on zona.idzona = estado.idzona "
                                        . "LEFT JOIN "
                                        . "estatus on estatus.idestatus = reporte.idestatus "
                                        . "LEFT JOIN "
                                        . "subclasificacion on subclasificacion.idsubclasificacion = reporte.idsubclf "
                                        . "LEFT JOIN "
                                        . "clasificacion on clasificacion.idclasificacion = subclasificacion.idclasificacion "
                                        . "LEFT JOIN "
                                        . "tiposervicio on tiposervicio.idtiposervicio = reporte.idtiposervicio "
                                        . "LEFT JOIN "
                                        . "corporativo on corporativo.idcorporativo = reporte.idcorporativo "
                                        . "LEFT JOIN "
                                        . "taller on reporte.idusrtaller = taller.idtaller "
                                        . "{$wheresql} "
                                        . "ORDER BY reporte.idreporte DESC";
                                //}
                                //var_dump($query);
                                //die();

                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $reportes = $stmt->fetchAll();

                                if (count($reportes) != 0) {

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "reportes encontrados!!",
                                        "reportes" => $reportes
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 401,
                                        "msg" => "no hay usuarios!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function selectRefaccionesAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            $json = $request->get("json", null);

                            if ($json != null) {

                                $params = json_decode($json);
                                $idreporte = ( $params->idreporte != null ) ? $params->idreporte : null;

                                //SOLO SI SE LLAMA DESDE ALGUN REPORTE
                                if ($idreporte != null) {

                                    $query = "SELECT * FROM detallerefacciones "
                                            . "LEFT JOIN refaccion on  detallerefacciones.idrefaccion = refaccion.idrefaccion "
                                            . "LEFT JOIN servicio on refaccion.idservicio = servicio.idservicio "
                                            . "LEFT JOIN modelo on refaccion.idmodelo = modelo.idmodelo "
                                            . "WHERE detallerefacciones.idreporte = $idreporte";


                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $isset_refaccion = $stmt->fetchAll();

                                    if (count($isset_refaccion) != 0) {

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "refacciones encontradas!!",
                                            "refacciones" => $isset_refaccion
                                        );
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 400,
                                            "msg" => "La refaccion o el taller no existe en la BD!!"
                                        );
                                    }
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
   public function deleteReporteAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            $json = $request->get("json", null);

                            if ($json != null) {

                                $params = json_decode($json);
                                $idreporte = ( $params->idreporte != null ) ? $params->idreporte : null;

                                //SOLO SI SE LLAMA DESDE ALGUN REPORTE
                                if ($idreporte != null) {
                                    $db = $em->getConnection();
                                    $query = "SELECT * FROM detallerefacciones WHERE idreporte = $idreporte";


                                    
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $isset_refaccion = $stmt->fetchAll();

                                    if (count($isset_refaccion) != 0) {
                                        foreach ($isset_refaccion as $row) {
                                            $idrefacciondetalle = $row['idrefacciondetalle'];
                                            $query = "DELETE FROM detallerefacciones WHERE idrefacciondetalle = $idrefacciondetalle";
                                            $stmt = $db->prepare($query);

                                            $params = array();

                                            $stmt->execute($params);
                                        }
                                    }
                                    
                                    $query = "SELECT * FROM detalleencuesta WHERE idreporte = $idreporte";

                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $encuestas = $stmt->fetchAll();

                                    if (count($encuestas) != 0) {
                                        foreach ($encuestas as $row) {
                                            $iddetalleencu = $row['iddetalleencu'];
                                            $query = "DELETE FROM detalleencuesta WHERE iddetalleencu = $iddetalleencu";

                                            $stmt = $db->prepare($query);

                                            $params = array();

                                            $stmt->execute($params);
                                        }
                                    }
                                    
                                    $query = "DELETE FROM reporte WHERE idreporte = $idreporte";

                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);
                                    
                                    $data = array(
                                        "status" => "sucess",
                                        "code" => 200,
                                        "msg" => "reporte eliminado!!"
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
}
