<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackendBundle\Entity\Refaccion;
use BackendBundle\Entity\Usuario;

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

/**
 * Description of RefaccionesController
 *
 * @author brianaboytesmorales
 */

class RefaccionController extends Controller {
    
    public function insertAction(Request $request) {

        /* MENSAJE POR DEFECTO SI NO SE CUMPLE NINGUNA DE LAS VALIDACIONES */
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        /* TRY-CATCH POR SI HAY UN ERROR EN LA EJECUCION */
        try {

            /* OBTENERMOS EL API KEY DEL REQUEST */
            $hash = $request->get("authorization", null);

            /* SI EXISTE EL API KEY ENTRA */
            if ($hash != null) {

                /* HACEMOS LA INSTANCIA CON LOS SERVICIOS HELPERS */
                $helpers = $this->get("app.helpers");

                /* LIBRERIAS DE LOS SERVICIOS DE AUTENTIFICACION DE LA APY KEY */
                $authCheck = $helpers->authCheck($hash);

                /* COMPRUEBA SI ES UNA APY KEY VALIDA */
                if ($authCheck == true) {

                    /* OBTIENE LOS DATOS DEL USUARIO DE LA APY KEY */
                    $identity = $helpers->authCheck($hash, true);

                    /* OBTIENE EL ID DEL USUARIO */
                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null;

                    /* SI EL ID DEL USUARIO ES DIFERENTE DE NULL ENTRA */
                    if ($idusuario != null) {
                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 

                        /* BUSCAMOS EL USUARIO EN LA BASE DE DATOS */
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;
                        /* SI EXISTE EL USUARIO ENTRA */
                        if (count($isset_user) != 0) {

                            /* VALIDA LOS ROLES DE USUARIO */
                            if ($idrol == 1 || $idrol == 2) {
                                /* OBTIENE EL JSON DEL REQUEST */
                                $json = $request->get("json", null);

                                /* VALIDA SI EXISTE EL JSON */
                                if ($json != null) {

                                    /* DECODIFICA EL JSON PARA USAR SUS DATOS */
                                    $jsondecode = json_decode($json);

                                    /* DATOS DE LA SOLICITUD */
                                    $idmodelo = ( $jsondecode->idmodelo != null ) ? $jsondecode->idmodelo : null;
                                    $idservicio = ( $jsondecode->idservicio != null ) ? $jsondecode->idservicio : null;
                                    $nombrerefaccion = ( $jsondecode->nombrerefaccion != null ) ? $jsondecode->nombrerefaccion : null;
                                    $cantidadmax = ( $jsondecode->cantidadmax != null ) ? $jsondecode->cantidadmax : null;

                                    /* SI DATA EXISTE ENTRA A EJECUTAR LA CONSULTA */
                                    if ($nombrerefaccion != null && $idmodelo != null && $idservicio != null) {

                                        $query = "INSERT INTO "
                                                . "refaccion (nombrerefaccion, idmodelo, idservicio, cantidadmax) "
                                                . "VALUES ('$nombrerefaccion', $idmodelo, $idservicio, $cantidadmax);";

                                        $db = $em->getConnection();
                                        $stmt = $db->prepare($query);
                                        $params = array();
                                        $stmt->execute($params);

                                        $data = array(
                                            "status" => "Sucess!",
                                            "code" => 200,
                                            "msg" => "refaccion creado"
                                        );
                                    } else {

                                        /* SI FALTA ALGUN DATO PRIMORDIAL MANDA ESTOS DATOS */
                                        $data = array(
                                            "status" => "error",
                                            "code" => 401,
                                            "msg" => "Faltan datos"
                                        );
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            /* SI HAY ALGUN ERROR EN LA EJECUCION MANDA ESTOS DATOS */
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    public function selectAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            $json = $request->get("json", null);

                            if ($json != null) {

                                $params = json_decode($json);
                                $idmodelo = ( $params->idmodelo != null ) ? $params->idmodelo : null;

                                //SOLO SI SE LLAMA DESDE ALGUN REPORTE
                                if ($idmodelo != null) {

                                    $query = "SELECT * FROM refaccion "
                                            . "LEFT JOIN servicio on servicio.idservicio = refaccion.idservicio "
                                            . "LEFT JOIN modelo on modelo.idmodelo = refaccion.idmodelo "
                                            . "WHERE refaccionactiva = 1 "
                                            . "AND modelo.idmodelo =".$idmodelo;


                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $isset_refaccion = $stmt->fetchAll();

                                    if (count($isset_refaccion) != 0) {

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "refacciones encontradas!!",
                                            "refacciones" => $isset_refaccion
                                        );
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 400,
                                            "msg" => "La refaccion o el taller no existe en la BD!!"
                                        );
                                    }
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    public function updateAction(Request $request) {

        /* MENSAJE POR DEFECTO SI NO SE CUMPLE NINGUNA DE LAS VALIDACIONES */
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        /* TRY-CATCH POR SI HAY UN ERROR EN LA EJECUCION */
        try {

            /* OBTENERMOS EL API KEY DEL REQUEST */
            $hash = $request->get("authorization", null);

            /* SI EXISTE EL API KEY ENTRA */
            if ($hash != null) {

                /* HACEMOS LA INSTANCIA CON LOS SERVICIOS HELPERS */
                $helpers = $this->get("app.helpers");

                /* LIBRERIAS DE LOS SERVICIOS DE AUTENTIFICACION DE LA APY KEY */
                $authCheck = $helpers->authCheck($hash);

                /* COMPRUEBA SI ES UNA APY KEY VALIDA */
                if ($authCheck == true) {

                    /* OBTIENE LOS DATOS DEL USUARIO DE LA APY KEY */
                    $identity = $helpers->authCheck($hash, true);

                    /* OBTIENE EL ID DEL USUARIO */
                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null;

                    /* SI EL ID DEL USUARIO ES DIFERENTE DE NULL ENTRA */
                    if ($idusuario != null) {
                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 

                        /* BUSCAMOS EL USUARIO EN LA BASE DE DATOS */
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;
                        /* SI EXISTE EL USUARIO ENTRA */
                        if (count($isset_user) != 0) {

                            /* VALIDA LOS ROLES DE USUARIO */
                            if ($idrol == 1 || $idrol == 2) {
                                /* OBTIENE EL JSON DEL REQUEST */
                                $json = $request->get("json", null);

                                /* VALIDA SI EXISTE EL JSON */
                                if ($json != null) {

                                    /* DECODIFICA EL JSON PARA USAR SUS DATOS */
                                    $jsondecode = json_decode($json);

                                    /* DATOS DE LA SOLICITUD */
                                    $idrefaccion = ( $jsondecode->idrefaccion != null ) ? $jsondecode->idrefaccion : null;
                                    $idmodelo = ( $jsondecode->idmodelo != null ) ? $jsondecode->idmodelo : null;
                                    $idservicio = ( $jsondecode->idservicio != null ) ? $jsondecode->idservicio : null;
                                    $nombrerefaccion = ( $jsondecode->nombrerefaccion != null ) ? $jsondecode->nombrerefaccion : null;
                                    $cantidadmax = ( $jsondecode->cantidadmax != null ) ? $jsondecode->cantidadmax : null;
                                    $refaccionactiva = ( $jsondecode->refaccionactiva != null ) ? $jsondecode->refaccionactiva : null;
                                    /* SI DATA EXISTE ENTRA A EJECUTAR LA CONSULTA */
                                    if ($idrefaccion != null && $nombrerefaccion != null) {

                                        $query = "UPDATE refaccion "
                                                . "SET nombrerefaccion = '{$nombrerefaccion}', "
                                                . "idmodelo= {$idmodelo}, "
                                                . "idservicio= {$idservicio}, "
                                                . "cantidadmax = {$cantidadmax}, "
                                                . "refaccionactiva = {$refaccionactiva} "
                                                . "WHERE idrefaccion = {$idrefaccion};";

                                        $db = $em->getConnection();
                                        $stmt = $db->prepare($query);
                                        $params = array();
                                        $stmt->execute($params);

                                        $data = array(
                                            "status" => "Sucess!",
                                            "code" => 200,
                                            "msg" => "Refaccion actualizado"
                                        );
                                    } else {

                                        /* SI FALTA ALGUN DATO PRIMORDIAL MANDA ESTOS DATOS */
                                        $data = array(
                                            "status" => "error",
                                            "code" => 401,
                                            "msg" => "Faltan datos"
                                        );
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            /* SI HAY ALGUN ERROR EN LA EJECUCION MANDA ESTOS DATOS */
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    public function insertdetalleAction(Request $request) {

        /* MENSAJE POR DEFECTO SI NO SE CUMPLE NINGUNA DE LAS VALIDACIONES */
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        /* TRY-CATCH POR SI HAY UN ERROR EN LA EJECUCION */
        try {

            /* OBTENERMOS EL API KEY DEL REQUEST */
            $hash = $request->get("authorization", null);

            /* SI EXISTE EL API KEY ENTRA */
            if ($hash != null) {

                /* HACEMOS LA INSTANCIA CON LOS SERVICIOS HELPERS */
                $helpers = $this->get("app.helpers");

                /* LIBRERIAS DE LOS SERVICIOS DE AUTENTIFICACION DE LA APY KEY */
                $authCheck = $helpers->authCheck($hash);

                /* COMPRUEBA SI ES UNA APY KEY VALIDA */
                if ($authCheck == true) {

                    /* OBTIENE LOS DATOS DEL USUARIO DE LA APY KEY */
                    $identity = $helpers->authCheck($hash, true);

                    /* OBTIENE EL ID DEL USUARIO */
                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null;

                    /* SI EL ID DEL USUARIO ES DIFERENTE DE NULL ENTRA */
                    if ($idusuario != null) {
                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 

                        /* BUSCAMOS EL USUARIO EN LA BASE DE DATOS */
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;
                        /* SI EXISTE EL USUARIO ENTRA */
                        if (count($isset_user) != 0) {

                            /* VALIDA LOS ROLES DE USUARIO */
                            if ($idrol == 1) {
                                /* OBTIENE EL JSON DEL REQUEST */
                                $json = $request->get("json", null);

                                /* VALIDA SI EXISTE EL JSON */
                                if ($json != null) {

                                    /* DATOS DE LA SOLICITUD */
                                    $jsondecode = json_decode($json, true);
                                    $db = $em->getConnection();
                                    foreach ($jsondecode as $row) {
                                        $cantidad = $row['cantidad'];
                                        $idrefaccion = $row['idrefaccion'];
                                        $idreporte = $row['idreporte'];

                                        $queryVerifica = "select * from detallerefacciones "
                                                . "WHERE idrefaccion = {$idrefaccion} AND idreporte = {$idreporte}";

                                        $stmtver = $db->prepare($queryVerifica);
                                        $paramsver = array();
                                        $stmtver->execute($paramsver);
                                        $refa = $stmtver->fetchAll();

                                        if (count($refa) == 0) {
                                            $query = "INSERT INTO detallerefacciones(cantidad, idrefaccion, idreporte) "
                                                    . "VALUES ($cantidad, $idrefaccion, $idreporte)";

                                            
                                            $stmt = $db->prepare($query);
                                            $params = array();
                                            $stmt->execute($params);
                                        }
                                    }
                                    $data = array(
                                        "status" => "Sucess!",
                                        "code" => 200,
                                        "msg" => "refaccion agregado"
                                    );
                                    /* SI DATA EXISTE ENTRA A EJECUTAR LA CONSULTA */
                                    /* if ($nombrerefaccion != null && $idmodelo != null && $idservicio != null) {

                                      $query = "INSERT INTO "
                                      . "refaccion (nombrerefaccion, idmodelo, idservicio, cantidadmax) "
                                      . "VALUES ('$nombrerefaccion', $idmodelo, $idservicio, $cantidadmax);";

                                      $db = $em->getConnection();
                                      $stmt = $db->prepare($query);
                                      $params = array();
                                      $stmt->execute($params);

                                      $data = array(
                                      "status" => "Sucess!",
                                      "code" => 200,
                                      "msg" => "refaccion creado"
                                      );
                                      } else {


                                      $data = array(
                                      "status" => "error",
                                      "code" => 401,
                                      "msg" => "Faltan datos"
                                      );
                                      } */
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            /* SI HAY ALGUN ERROR EN LA EJECUCION MANDA ESTOS DATOS */
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
}
