<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackendBundle\Entity\Refaccion;
use BackendBundle\Entity\Usuario;

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

/**
 * Description of EncuestaController
 *
 * @author brianaboytesmorales
 */
class EncuestaController extends Controller {
    
    public function selectAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $query = "SELECT * FROM "
                                    . "encuesta "
                                    . "WHERE preguntaactiva = 1";


                            $db = $em->getConnection();
                            $stmt = $db->prepare($query);

                            $params = array();

                            $stmt->execute($params);

                            $isset_ciudad = $stmt->fetchAll();

                            if (count($isset_ciudad) != 0) {

                                $data = array(
                                    "status" => "succes!!",
                                    "code" => 200,
                                    "msg" => "Modelos encontradas!!",
                                    "encuestas" => $isset_ciudad
                                );
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 400,
                                    "msg" => "El modelo no existe en la BD!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function insertAction(Request $request) {

        /* MENSAJE POR DEFECTO SI NO SE CUMPLE NINGUNA DE LAS VALIDACIONES */
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        /* TRY-CATCH POR SI HAY UN ERROR EN LA EJECUCION */
        try {

            /* OBTENERMOS EL API KEY DEL REQUEST */
            $hash = $request->get("authorization", null);

            /* SI EXISTE EL API KEY ENTRA */
            if ($hash != null) {

                /* HACEMOS LA INSTANCIA CON LOS SERVICIOS HELPERS */
                $helpers = $this->get("app.helpers");

                /* LIBRERIAS DE LOS SERVICIOS DE AUTENTIFICACION DE LA APY KEY */
                $authCheck = $helpers->authCheck($hash);

                /* COMPRUEBA SI ES UNA APY KEY VALIDA */
                if ($authCheck == true) {

                    /* OBTIENE LOS DATOS DEL USUARIO DE LA APY KEY */
                    $identity = $helpers->authCheck($hash, true);

                    /* OBTIENE EL ID DEL USUARIO */
                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null;

                    /* SI EL ID DEL USUARIO ES DIFERENTE DE NULL ENTRA */
                    if ($idusuario != null) {
                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 

                        /* BUSCAMOS EL USUARIO EN LA BASE DE DATOS */
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;
                        /* SI EXISTE EL USUARIO ENTRA */
                        if (count($isset_user) != 0) {

                            /* VALIDA LOS ROLES DE USUARIO */
                            
                                /* OBTIENE EL JSON DEL REQUEST */
                                $json = $request->get("json", null);

                                /* VALIDA SI EXISTE EL JSON */
                                if ($json != null) {

                                    /* DECODIFICA EL JSON PARA USAR SUS DATOS */
                                    $jsondecode = json_decode($json, true);

                                    /* DATOS DE LA SOLICITUD */
                                    //$encuesta = ( (array)$jsondecode->encuesta != null ) ? (array)$jsondecode->encuesta : null;
                                    $db = $em->getConnection();
                                    foreach ($jsondecode as $row) {
                                    $idpregunta = $row['idpregunta'];
                                    $idreporte = $row['idreporte'];
                                    $no = $row['no'];
                                    $si = $row['si'];
                                    $valoracion = $row['valoracion'];
                                    $aceptoencuesta = $row['aceptoencuesta'];

                                    $queryVerifica = "select * from detalleencuesta "
                                            . "WHERE idpregunta = {$idpregunta} AND idreporte = {$idreporte}";

                                    $stmtver = $db->prepare($queryVerifica);
                                    $paramsver = array();
                                    $stmtver->execute($paramsver);
                                    $encuestas = $stmtver->fetchAll();
                                    if (count($encuestas) == 0) {
                                        $query = "INSERT INTO detalleencuesta(idpregunta, idreporte, si, no, valoracion, aceptoencuesta)"
                                                . "VALUES ($idpregunta, $idreporte, $si, $no, $valoracion, $aceptoencuesta)";


                                        $stmt = $db->prepare($query);
                                        $params = array();
                                        $stmt->execute($params);
                                    }
                                }
                                    
                                    $data = array(
                                            "status" => "Sucess!",
                                            "code" => 200,
                                            "msg" => "encuesta insertada"
                                        );
                                    
                                    /* SI DATA EXISTE ENTRA A EJECUTAR LA CONSULTA */
                                    /*if ($encuesta != null ) {

                                        $query = "INSERT INTO "
                                                . "modelo (nombremodelo) "
                                                . "VALUES ('$nombremodelo');";

                                        $db = $em->getConnection();
                                        $stmt = $db->prepare($query);
                                        $params = array();
                                        $stmt->execute($params);

                                        $data = array(
                                            "status" => "Sucess!",
                                            "code" => 200,
                                            "msg" => "modelo creado"
                                        );
                                    } else {

                                       
                                        $data = array(
                                            "status" => "error",
                                            "code" => 401,
                                            "msg" => "Faltan datos"
                                        );
                                    }*/
                                }
                            
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            /* SI HAY ALGUN ERROR EN LA EJECUCION MANDA ESTOS DATOS */
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function selectresAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );
                        if (count($isset_user) != 0) {
                            $json = $request->get("json", null);

                            if ($json != null) {

                                $jsondecode = json_decode($json);

                                $idreporte = ($jsondecode->idreporte != null ) ? $jsondecode->idreporte : null;
                                $idciudad = ($jsondecode->idciudad != null ) ? $jsondecode->idciudad : null;
                                $idestado = ($jsondecode->idestado != null ) ? $jsondecode->idestado : null;
                                $idzona = ($jsondecode->idzona != null ) ? $jsondecode->idzona : null;
                                $idcorporativo = ($jsondecode->idcorporativo != null ) ? $jsondecode->idcorporativo : null;
                                
                                $fechainicio = ($jsondecode->fechainicial != null ) ? $jsondecode->fechainicial : null;
                                $fechafinal = ($jsondecode->fechafinal != null ) ? $jsondecode->fechafinal : null;
                                
                               
                                $where = "";
                                if($idreporte != null){
                                    $where = "detalleencuesta.idreporte = {$idreporte}";
                                }
                                if($idciudad != null){
                                    $where = "ciudad.idciudad = {$idciudad}";
                                }
                                if($idestado != null){
                                    $where = "estado.idestado = {$idestado}";
                                }
                                if($idzona != null){
                                    $where = "zona.idzona = {$idzona}";
                                }
                                if($idcorporativo != null){
                                    $where = "reporte.idcorporativo = {$idzona}";
                                }
                                //PARA PODER BRINDAR 

                                if($fechainicio != null && $fechafinal != null){
                                    $where = " (detalleencuesta.fecha >= $fechainicio AND detalleencuesta.fecha <= $fechafinal) AND $where";
                                }
                                $query = "SELECT * FROM "
                                        . "detalleencuesta "
                                        . "LEFT JOIN "
                                        . "encuesta on detalleencuesta.idpregunta = encuesta.idpregunta "
                                        . "LEFT JOIN "
                                        . "reporte on reporte.idreporte = detalleencuesta.idreporte "
                                        . "LEFT JOIN "
                                        . "ciudad on ciudad.idciudad = reporte.idciudad "
                                        . "LEFT JOIN "
                                        . "estado on estado.idestado = ciudad.idestado "
                                        . "LEFT JOIN "
                                        . "zona on zona.idzona = estado.idzona "
                                        . "WHERE {$where} ";

                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $isset_ciudad = $stmt->fetchAll();

                                if (count($isset_ciudad) != 0) {

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "encuestas encontradas!!",
                                        "encuesta" => $isset_ciudad
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 402,
                                        "msg" => "la encuesta no existe en la BD!!"
                                    );
                                }
                            } else {
                                $query = "SELECT * FROM "
                                        . "detalleencuesta "
                                        . "LEFT JOIN "
                                        . "encuesta on detalleencuesta.idpregunta = encuesta.idpregunta "
                                        . "ORDER BY detalleencuesta.iddetalleencu DESC LIMIT 30";


                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $isset_ciudad = $stmt->fetchAll();

                                if (count($isset_ciudad) != 0) {

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "encuestas encontradas!!",
                                        "encuesta" => $isset_ciudad
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 402,
                                        "msg" => "no hay encuestas!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
}
