<?php

namespace AppBundle\Controller;

use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

class DefaultController extends Controller
{
    
    public function indexAction(Request $request)
    {
        // replace this example code with whatever you need
        return $this->render('default/index.html.twig', [
            'base_dir' => realpath($this->getParameter('kernel.root_dir').'/..'),
        ]);
    }
    
    public function pruebasAction(Request $request)
    {
        $helpers = $this->get("app.helpers");
        $gm = $this->getDoctrine()->getManager();
        $user = $gm->getRepository('BackendBundle:Usuario')->findAll(1);
        return $helpers->json($user);
    }
    
        public function loginAction(Request $request){
        $helper = $this->get("app.helpers");
        $jwt_auth = $this->get("app.jwt_auth");
        
        $json = $request->get("json",null);
        
        if($json != null){
            $params = json_decode($json);
            
            $email = (isset($params->email)) ? $params->email : null;
            
            $password = (isset($params->password)) ? $params->password : null;
            $getHash = (isset($params->gethash)) ? $params->gethash : null;
            
            $emailContrint= new Assert\Email();
            $emailContrint->message= "this email is not valid";
            
            $validate_email = $this->get("validator")->validate($email, $emailContrint);
            
            $pwd = hash('sha256', $password);
            
            if(count($validate_email) == 0 && $password != null){

               if($getHash == null){
                   $singup = $jwt_auth->signup($email, $pwd);      
               }
               else{
                   $singup = $jwt_auth->signup($email, $pwd, true);
               }
               return new JsonResponse($singup);
                
            }else{
                return $helper->json(array(
                    "status" => "error",
                    "data" => "Login not valid!!"
                ));
                
            }
            
        }else {
            return $helper->json(array(
                    "status" => "error",
                    "data" => "send json with post!!"
                ));
        }
        
        
    }
}
