<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackendBundle\Entity\Usuario;

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

/**
 * Description of corporativoController
 *
 * @author brianaboytesmorales
 */
class CorporativoController extends Controller{
    
    public function selectAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $json = $request->get("json", null);
                    $params = json_decode($json);
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            if ($json != null) {

                                $idcorporativo = ( $params->idcorporativo != null ) ? $params->idcorporativo : null;

                                if ($idciudad != null) {

                                    $query = "SELECT "
                                        . "*"
                                        . "FROM "
                                        . "corporativo "
                                        . "WHERE idcorporativo = {$idciudad}";


                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $isset_ciudad = $stmt->fetchAll();

                                    if (count($isset_ciudad) != 0) {

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "corporativo encontrado!!",
                                            "ciudad" => $isset_ciudad
                                        );
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 400,
                                            "msg" => "El corporativo no existe en la BD!!"
                                        );
                                    }
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            } else {

                                $query = "SELECT "
                                        . "*"
                                        . "FROM "
                                        . "corporativo "
                                        . "Limit 30";


                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $isset_corporativo = $stmt->fetchAll();
                                if (count($isset_corporativo) != 0) {

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "corporativos encontrados!!",
                                        "corporativos" => $isset_corporativo
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "no hay corporativos en la BD!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function bscorporativoAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $json = $request->get("json", null);
                    $params = json_decode($json);
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            if ($json != null) {

                                $idcorporativo = ( $params->idcorporativo != null ) ? $params->idcorporativo : null;
                                $idusuario = ( $params->idusuario != null ) ? $params->idusuario : null;

                                $idciudad = ( $params->idciudad != null ) ? $params->idciudad : null;
                                $idestado = ( $params->idestado != null ) ? $params->idestado : null;
                                $idzona = ( $params->idzona != null ) ? $params->idzona : null;

                                $nomcorporativo = ( $params->nomcorporativo != null ) ? $params->nomcorporativo : null;

                                $fechainicial = ( $params->fechainicial != null ) ? $params->fechainicial : null;
                                $fechafinal = ( $params->fechafinal != null ) ? $params->fechafinal : null;

                                $wheresql = "";

                                if ($idcorporativo != null || $idusuario != null || $idciudad != null ||
                                        $idestado != null || $idzona != null || $nomcorporativo != null || ($fechainicial != null && $fechafinal != null)) {

                                    $wheresql = "{$wheresql} WHERE ";

                                    if ($fechainicial != null && $fechafinal != null) {
                                        $wheresql = " {$wheresql} corporativo.fechacreacioncorp >= '{$fechainicial}' AND corporativo.fechacreacioncorp <= '{$fechafinal}' ";
                                        if ($idcorporativo != null || $idusuario != null || $idciudad != null ||
                                                $idestado != null || $idzona != null || $nomcorporativo != null) {
                                            $wheresql = " {$wheresql} AND ";
                                        }
                                    }

                                    if ($idcorporativo != null) {
                                        $wheresql = " {$wheresql} corporativo.idcorporativo = {$idcorporativo} ";
                                        if ($idusuario != null || $idciudad != null ||
                                                $idestado != null || $idzona != null || $nomcorporativo != null) {
                                            $wheresql = " {$wheresql} AND ";
                                        }
                                    }
                                    if ($idusuario != null) {
                                        $wheresql = " {$wheresql} corporativo.idusuario = {$idusuario} ";
                                        if ($idciudad != null ||
                                                $idestado != null || $idzona != null || $nomcorporativo != null) {
                                            $wheresql = " {$wheresql} AND ";
                                        }
                                    }
                                    if ($idciudad != null) {
                                        $wheresql = " {$wheresql} corporativo.idciudad = {$idciudad} ";
                                        if ($idestado != null || $idzona != null || $nomcorporativo != null) {
                                            $wheresql = " {$wheresql} AND ";
                                        }
                                    }
                                    if ($idestado != null) {
                                        $wheresql = " {$wheresql} estado.idestado = {$idestado} ";
                                        if ($idzona != null || $nomcorporativo != null) {
                                            $wheresql = " {$wheresql} AND ";
                                        }
                                    }
                                    if ($idzona != null) {
                                        $wheresql = " {$wheresql} zona.idzona = {$idzona} ";
                                        if ($nomcorporativo != null) {
                                            $wheresql = " {$wheresql} AND ";
                                        }
                                    }
                                    if ($nomcorporativo != null) {
                                        $wheresql = " {$wheresql} corporativo.nomcorporativo = '{$nomcorporativo}' ";
                                    }




                                    $query = "SELECT "
                                            . "*"
                                            . "FROM "
                                            . "corporativo "
                                            . "LEFT JOIN "
                                            . "usuario on usuario.idusuario = corporativo.idusuario "
                                            . "LEFT JOIN "
                                            . "ciudad on ciudad.idciudad = corporativo.idciudad "
                                            . "LEFT JOIN "
                                            . "estado on estado.idestado = ciudad.idestado "
                                            . "LEFT JOIN "
                                            . "zona on zona.idzona = estado.idzona "
                                            . "$wheresql";


                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $isset_ciudad = $stmt->fetchAll();

                                    if (count($isset_ciudad) != 0) {

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "corporativo encontrado!!",
                                            "corporativos" => $isset_ciudad
                                        );
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 401,
                                            "msg" => "El corporativo no existe en la BD!!"
                                        );
                                    }
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            } else {

                                $query = "SELECT "
                                        . "*"
                                        . "FROM "
                                        . "corporativo "
                                        . "LEFT JOIN "
                                        . "usuario on usuario.idusuario = corporativo.idusuario "
                                        . "LEFT JOIN "
                                        . "ciudad on ciudad.idciudad = corporativo.idciudad "
                                        . "LEFT JOIN "
                                        . "estado on estado.idestado = ciudad.idestado "
                                        . "LEFT JOIN "
                                        . "zona on zona.idzona = estado.idzona "
                                        . "ORDER BY corporativo.idcorporativo DESC LIMIT 30";



                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $isset_corporativo = $stmt->fetchAll();
                                if (count($isset_corporativo) != 0) {

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "corporativos encontrados!!",
                                        "corporativos" => $isset_corporativo
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "no hay corporativos en la BD!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    /*AGREGAR A API*/
    public function newAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $json = $request->get("json", null);
                    $params = json_decode($json);
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            if ($json != null) {

                                $nomcorporativo = ( $params->nomcorporativo != null ) ? $params->nomcorporativo : null;
                                $idusuario = ( $params->idusuario != null ) ? $params->idusuario : null;
                                $idciudad = ( $params->idciudad != null ) ? $params->idciudad : null;
                                $sla = ( $params->sla != null ) ? $params->sla : null;
                                $telefonocorp = ( $params->telefonocorp != null ) ? $params->telefonocorp : null;
                                $correocorp = ( $params->correocorp != null ) ? $params->correocorp : null;
                                $permisos = ( $params->permisos != null ) ? $params->permisos : null;

                                if ($nomcorporativo != null && $idusuario != null && $idciudad != null && $sla != null && $telefonocorp != null && $correocorp != null && $permisos != null) {

                                    $query = "INSERT INTO corporativo(idusuario,idciudad,nomcorporativo,permisos,activo,sla,telefonocorp,correocorp) "
                                            . "VALUES ($idusuario,$idciudad,'$nomcorporativo',$permisos,1,$sla,'$telefonocorp','$correocorp')";


                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    $db = $em->getConnection();
                                    $data["status"] = 'success';
                                    $data["code"] = 200;
                                    $data["msg"] = 'New corporativo created !!';
                                    
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            } 
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    /*AGREGAR A API*/
    public function updateAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $json = $request->get("json", null);
                    $params = json_decode($json);
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            if ($json != null) {

                                $idcorporativo = ( $params->idcorporativo != null ) ? $params->idcorporativo : null;
                                $nomcorporativo = ( $params->nomcorporativo != null ) ? $params->nomcorporativo : null;
                                $idusuario = ( $params->idusuario != null ) ? $params->idusuario : null;
                                $idciudad = ( $params->idciudad != null ) ? $params->idciudad : null;
                                $sla = ( $params->sla != null ) ? $params->sla : null;
                                $telefonocorp = ( $params->telefonocorp != null ) ? $params->telefonocorp : null;
                                $correocorp = ( $params->correocorp != null ) ? $params->correocorp : null;
                                $permisos = ( $params->permisos != null ) ? $params->permisos : null;

                                if ($nomcorporativo != null && $idusuario != null && $idciudad != null && $sla != null && $telefonocorp != null && $correocorp != null && $permisos != null) {

                                    $query = "UPDATE corporativo "
                                            . "SET idusuario = $idusuario, "
                                            . "idciudad = $idciudad, "
                                            . "nomcorporativo = '$nomcorporativo', "
                                            . "permisos = $permisos, "
                                            . "sla = $sla, "
                                            . "telefonocorp = '$telefonocorp', "
                                            . "correocorp = '$correocorp' "
                                            . "WHERE idcorporativo = $idcorporativo";


                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    $db = $em->getConnection();
                                    $data["status"] = 'success';
                                    $data["code"] = 200;
                                    $data["msg"] = 'corporativo update created !!';
                                    
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            } 
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    /*AGREGAR A API*/
    public function activoAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $json = $request->get("json", null);
                    $params = json_decode($json);
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            if ($json != null) {

                                
                                $idcorporativo = ( $params->idcorporativo != null ) ? $params->idcorporativo : null;
                                $activo = ( $params->activo != null ) ? $params->activo : null;

                                if ($idcorporativo != null && $activo != null) {

                                    $query = "UPDATE corporativo SET activo = $activo "
                                            . "WHERE idcorporativo = $idcorporativo";


                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    $db = $em->getConnection();
                                    $data["status"] = 'success';
                                    $data["code"] = 200;
                                    $data["msg"] = 'corporativo update !!';
                                    
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            } 
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function uploadGraficaAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $file = $request->files->get("image");
                            if (!empty($file) && $file != null) {
                                $ext = $file->guessExtension(); //obtenemos la extencion
                                
                                if ($ext == "jpeg" || $ext == "jpg" || $ext == "png") {

                                    $file_name = time() . "." . $ext; //le asignamos un nombre diferente
                                    $file->move("uploads/graficascorporativos", $file_name); //subir al fichero
                                    ///aqui va el insert sql

                                    $json = $request->get("json", null);
                                    $jsondecode = json_decode($json);
                                    
                                    $idcorporativo = ( $jsondecode->idcorporativo != null ) ? $jsondecode->idcorporativo : null;
                                    
                                    //$grafica = ( $jsondecode->grafica != null ) ? $jsondecode->grafica : null;

                                    $query = "SET grafica = 'https://apiitc.itcdemexico.com/suportapi/web/uploads/graficascorporativos/{$file_name}' ";
                                    /*if ($grafica == 1) {
                                        $query = "SET grafica = 'http://apiitc.itcdemexico.com/suportapi/web/uploads/reporte/{$file_name}'";
                                    }
                                    if ($grafica == 2) {
                                        $query = "SET grafica = 'http://apiitc.itcdemexico.com/suportapi/web/uploads/reporte/{$file_name}'";
                                    }*/

                                    $query = "UPDATE corporativo {$query} "
                                            . "WHERE idcorporativo = {$idcorporativo}";

                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "Imagenes cargadas correctamente!!"
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 402,
                                        "msg" => "ERROR DE ARCHIVO!!"
                                    );
                                }
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 401,
                                    "msg" => "erro al cargar imagenes!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
}
